import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BlueprintAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#location BlueprintAssignment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#lock_exclude_actions BlueprintAssignment#lock_exclude_actions}
    */
    readonly lockExcludeActions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#lock_exclude_principals BlueprintAssignment#lock_exclude_principals}
    */
    readonly lockExcludePrincipals?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#lock_mode BlueprintAssignment#lock_mode}
    */
    readonly lockMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#name BlueprintAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#parameter_values BlueprintAssignment#parameter_values}
    */
    readonly parameterValues?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#resource_groups BlueprintAssignment#resource_groups}
    */
    readonly resourceGroups?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#target_subscription_id BlueprintAssignment#target_subscription_id}
    */
    readonly targetSubscriptionId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#version_id BlueprintAssignment#version_id}
    */
    readonly versionId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#identity BlueprintAssignment#identity}
    */
    readonly identity: BlueprintAssignmentIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#timeouts BlueprintAssignment#timeouts}
    */
    readonly timeouts?: BlueprintAssignmentTimeouts;
}
export interface BlueprintAssignmentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#identity_ids BlueprintAssignment#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#type BlueprintAssignment#type}
    */
    readonly type: string;
}
export declare function blueprintAssignmentIdentityToTerraform(struct?: BlueprintAssignmentIdentityOutputReference | BlueprintAssignmentIdentity): any;
export declare class BlueprintAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BlueprintAssignmentIdentity | undefined;
    set internalValue(value: BlueprintAssignmentIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BlueprintAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#create BlueprintAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#delete BlueprintAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#read BlueprintAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment#update BlueprintAssignment#update}
    */
    readonly update?: string;
}
export declare function blueprintAssignmentTimeoutsToTerraform(struct?: BlueprintAssignmentTimeoutsOutputReference | BlueprintAssignmentTimeouts | cdktf.IResolvable): any;
export declare class BlueprintAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BlueprintAssignmentTimeouts | undefined;
    set internalValue(value: BlueprintAssignmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment azurerm_blueprint_assignment}
*/
export declare class BlueprintAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_blueprint_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment azurerm_blueprint_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BlueprintAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: BlueprintAssignmentConfig);
    get blueprintName(): string;
    get description(): string;
    get displayName(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _lockExcludeActions?;
    get lockExcludeActions(): string[];
    set lockExcludeActions(value: string[]);
    resetLockExcludeActions(): void;
    get lockExcludeActionsInput(): string[] | undefined;
    private _lockExcludePrincipals?;
    get lockExcludePrincipals(): string[];
    set lockExcludePrincipals(value: string[]);
    resetLockExcludePrincipals(): void;
    get lockExcludePrincipalsInput(): string[] | undefined;
    private _lockMode?;
    get lockMode(): string;
    set lockMode(value: string);
    resetLockMode(): void;
    get lockModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameterValues?;
    get parameterValues(): string;
    set parameterValues(value: string);
    resetParameterValues(): void;
    get parameterValuesInput(): string | undefined;
    private _resourceGroups?;
    get resourceGroups(): string;
    set resourceGroups(value: string);
    resetResourceGroups(): void;
    get resourceGroupsInput(): string | undefined;
    private _targetSubscriptionId?;
    get targetSubscriptionId(): string;
    set targetSubscriptionId(value: string);
    get targetSubscriptionIdInput(): string | undefined;
    get type(): string;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    get versionIdInput(): string | undefined;
    private _identity;
    get identity(): BlueprintAssignmentIdentityOutputReference;
    putIdentity(value: BlueprintAssignmentIdentity): void;
    get identityInput(): BlueprintAssignmentIdentity | undefined;
    private _timeouts;
    get timeouts(): BlueprintAssignmentTimeoutsOutputReference;
    putTimeouts(value: BlueprintAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BlueprintAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
