import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#name DataAzurermApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#resource_group_name DataAzurermApplicationGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#timeouts DataAzurermApplicationGateway#timeouts}
    */
    readonly timeouts?: DataAzurermApplicationGatewayTimeouts;
}
export interface DataAzurermApplicationGatewayIdentity {
}
export declare function dataAzurermApplicationGatewayIdentityToTerraform(struct?: DataAzurermApplicationGatewayIdentity): any;
export declare class DataAzurermApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayIdentity | undefined;
    set internalValue(value: DataAzurermApplicationGatewayIdentity | undefined);
    get identityIds(): string[];
    get type(): string;
}
export declare class DataAzurermApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayIdentityOutputReference;
}
export interface DataAzurermApplicationGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#read DataAzurermApplicationGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApplicationGatewayTimeoutsToTerraform(struct?: DataAzurermApplicationGatewayTimeoutsOutputReference | DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApplicationGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermApplicationGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway azurerm_application_gateway}
*/
export declare class DataAzurermApplicationGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_application_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway azurerm_application_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApplicationGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationGatewayConfig);
    get id(): string;
    private _identity;
    get identity(): DataAzurermApplicationGatewayIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermApplicationGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApplicationGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApplicationGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
