import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApplicationSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group#name DataAzurermApplicationSecurityGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group#resource_group_name DataAzurermApplicationSecurityGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group#timeouts DataAzurermApplicationSecurityGroup#timeouts}
    */
    readonly timeouts?: DataAzurermApplicationSecurityGroupTimeouts;
}
export interface DataAzurermApplicationSecurityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group#read DataAzurermApplicationSecurityGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApplicationSecurityGroupTimeoutsToTerraform(struct?: DataAzurermApplicationSecurityGroupTimeoutsOutputReference | DataAzurermApplicationSecurityGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApplicationSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApplicationSecurityGroupTimeouts | undefined;
    set internalValue(value: DataAzurermApplicationSecurityGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group azurerm_application_security_group}
*/
export declare class DataAzurermApplicationSecurityGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_application_security_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group azurerm_application_security_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApplicationSecurityGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationSecurityGroupConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermApplicationSecurityGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApplicationSecurityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApplicationSecurityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
