import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAutomationVariableStringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string#automation_account_name DataAzurermAutomationVariableString#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string#name DataAzurermAutomationVariableString#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string#resource_group_name DataAzurermAutomationVariableString#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string#timeouts DataAzurermAutomationVariableString#timeouts}
    */
    readonly timeouts?: DataAzurermAutomationVariableStringTimeouts;
}
export interface DataAzurermAutomationVariableStringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string#read DataAzurermAutomationVariableString#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAutomationVariableStringTimeoutsToTerraform(struct?: DataAzurermAutomationVariableStringTimeoutsOutputReference | DataAzurermAutomationVariableStringTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAutomationVariableStringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAutomationVariableStringTimeouts | undefined;
    set internalValue(value: DataAzurermAutomationVariableStringTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string azurerm_automation_variable_string}
*/
export declare class DataAzurermAutomationVariableString extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_automation_variable_string";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string azurerm_automation_variable_string} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAutomationVariableStringConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAutomationVariableStringConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get value(): string;
    private _timeouts;
    get timeouts(): DataAzurermAutomationVariableStringTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAutomationVariableStringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAutomationVariableStringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
