import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBackupPolicyVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm#name DataAzurermBackupPolicyVm#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm#recovery_vault_name DataAzurermBackupPolicyVm#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm#resource_group_name DataAzurermBackupPolicyVm#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm#timeouts DataAzurermBackupPolicyVm#timeouts}
    */
    readonly timeouts?: DataAzurermBackupPolicyVmTimeouts;
}
export interface DataAzurermBackupPolicyVmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm#read DataAzurermBackupPolicyVm#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBackupPolicyVmTimeoutsToTerraform(struct?: DataAzurermBackupPolicyVmTimeoutsOutputReference | DataAzurermBackupPolicyVmTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBackupPolicyVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBackupPolicyVmTimeouts | undefined;
    set internalValue(value: DataAzurermBackupPolicyVmTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm azurerm_backup_policy_vm}
*/
export declare class DataAzurermBackupPolicyVm extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_backup_policy_vm";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm azurerm_backup_policy_vm} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBackupPolicyVmConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBackupPolicyVmConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermBackupPolicyVmTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBackupPolicyVmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBackupPolicyVmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
