import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBillingEnrollmentAccountScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#billing_account_name DataAzurermBillingEnrollmentAccountScope#billing_account_name}
    */
    readonly billingAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#enrollment_account_name DataAzurermBillingEnrollmentAccountScope#enrollment_account_name}
    */
    readonly enrollmentAccountName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#timeouts DataAzurermBillingEnrollmentAccountScope#timeouts}
    */
    readonly timeouts?: DataAzurermBillingEnrollmentAccountScopeTimeouts;
}
export interface DataAzurermBillingEnrollmentAccountScopeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope#read DataAzurermBillingEnrollmentAccountScope#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBillingEnrollmentAccountScopeTimeoutsToTerraform(struct?: DataAzurermBillingEnrollmentAccountScopeTimeoutsOutputReference | DataAzurermBillingEnrollmentAccountScopeTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBillingEnrollmentAccountScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBillingEnrollmentAccountScopeTimeouts | undefined;
    set internalValue(value: DataAzurermBillingEnrollmentAccountScopeTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope azurerm_billing_enrollment_account_scope}
*/
export declare class DataAzurermBillingEnrollmentAccountScope extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_billing_enrollment_account_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/billing_enrollment_account_scope azurerm_billing_enrollment_account_scope} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBillingEnrollmentAccountScopeConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBillingEnrollmentAccountScopeConfig);
    private _billingAccountName?;
    get billingAccountName(): string;
    set billingAccountName(value: string);
    get billingAccountNameInput(): string | undefined;
    private _enrollmentAccountName?;
    get enrollmentAccountName(): string;
    set enrollmentAccountName(value: string);
    get enrollmentAccountNameInput(): string | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): DataAzurermBillingEnrollmentAccountScopeTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBillingEnrollmentAccountScopeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBillingEnrollmentAccountScopeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
