import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareDatasetKustoDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database#name DataAzurermDataShareDatasetKustoDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database#share_id DataAzurermDataShareDatasetKustoDatabase#share_id}
    */
    readonly shareId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database#timeouts DataAzurermDataShareDatasetKustoDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareDatasetKustoDatabaseTimeouts;
}
export interface DataAzurermDataShareDatasetKustoDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database#read DataAzurermDataShareDatasetKustoDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetKustoDatabaseTimeoutsToTerraform(struct?: DataAzurermDataShareDatasetKustoDatabaseTimeoutsOutputReference | DataAzurermDataShareDatasetKustoDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareDatasetKustoDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataShareDatasetKustoDatabaseTimeouts | undefined;
    set internalValue(value: DataAzurermDataShareDatasetKustoDatabaseTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database azurerm_data_share_dataset_kusto_database}
*/
export declare class DataAzurermDataShareDatasetKustoDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_share_dataset_kusto_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database azurerm_data_share_dataset_kusto_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareDatasetKustoDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetKustoDatabaseConfig);
    get displayName(): string;
    get id(): string;
    get kustoClusterLocation(): string;
    get kustoDatabaseId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareId?;
    get shareId(): string;
    set shareId(value: string);
    get shareIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDataShareDatasetKustoDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareDatasetKustoDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataShareDatasetKustoDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
