import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDigitalTwinsInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/digital_twins_instance#name DataAzurermDigitalTwinsInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/digital_twins_instance#resource_group_name DataAzurermDigitalTwinsInstance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/digital_twins_instance#timeouts DataAzurermDigitalTwinsInstance#timeouts}
    */
    readonly timeouts?: DataAzurermDigitalTwinsInstanceTimeouts;
}
export interface DataAzurermDigitalTwinsInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/digital_twins_instance#read DataAzurermDigitalTwinsInstance#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDigitalTwinsInstanceTimeoutsToTerraform(struct?: DataAzurermDigitalTwinsInstanceTimeoutsOutputReference | DataAzurermDigitalTwinsInstanceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDigitalTwinsInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDigitalTwinsInstanceTimeouts | undefined;
    set internalValue(value: DataAzurermDigitalTwinsInstanceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/digital_twins_instance azurerm_digital_twins_instance}
*/
export declare class DataAzurermDigitalTwinsInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_digital_twins_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/digital_twins_instance azurerm_digital_twins_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDigitalTwinsInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDigitalTwinsInstanceConfig);
    get hostName(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDigitalTwinsInstanceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDigitalTwinsInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDigitalTwinsInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
