import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#name DataAzurermFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#resource_group_name DataAzurermFirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#timeouts DataAzurermFirewallPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermFirewallPolicyTimeouts;
}
export interface DataAzurermFirewallPolicyDns {
}
export declare function dataAzurermFirewallPolicyDnsToTerraform(struct?: DataAzurermFirewallPolicyDns): any;
export declare class DataAzurermFirewallPolicyDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallPolicyDns | undefined;
    set internalValue(value: DataAzurermFirewallPolicyDns | undefined);
    get networkRuleFqdnEnabled(): cdktf.IResolvable;
    get proxyEnabled(): cdktf.IResolvable;
    get servers(): string[];
}
export declare class DataAzurermFirewallPolicyDnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallPolicyDnsOutputReference;
}
export interface DataAzurermFirewallPolicyThreatIntelligenceAllowlist {
}
export declare function dataAzurermFirewallPolicyThreatIntelligenceAllowlistToTerraform(struct?: DataAzurermFirewallPolicyThreatIntelligenceAllowlist): any;
export declare class DataAzurermFirewallPolicyThreatIntelligenceAllowlistOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallPolicyThreatIntelligenceAllowlist | undefined;
    set internalValue(value: DataAzurermFirewallPolicyThreatIntelligenceAllowlist | undefined);
    get fqdns(): string[];
    get ipAddresses(): string[];
}
export declare class DataAzurermFirewallPolicyThreatIntelligenceAllowlistList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallPolicyThreatIntelligenceAllowlistOutputReference;
}
export interface DataAzurermFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#read DataAzurermFirewallPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFirewallPolicyTimeoutsToTerraform(struct?: DataAzurermFirewallPolicyTimeoutsOutputReference | DataAzurermFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermFirewallPolicyTimeouts | undefined;
    set internalValue(value: DataAzurermFirewallPolicyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy azurerm_firewall_policy}
*/
export declare class DataAzurermFirewallPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_firewall_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy azurerm_firewall_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallPolicyConfig);
    get basePolicyId(): string;
    get childPolicies(): string[];
    private _dns;
    get dns(): DataAzurermFirewallPolicyDnsList;
    get firewalls(): string[];
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get ruleCollectionGroups(): string[];
    tags(key: string): string | cdktf.IResolvable;
    private _threatIntelligenceAllowlist;
    get threatIntelligenceAllowlist(): DataAzurermFirewallPolicyThreatIntelligenceAllowlistList;
    get threatIntelligenceMode(): string;
    private _timeouts;
    get timeouts(): DataAzurermFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
