import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultManagedHardwareSecurityModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module#name DataAzurermKeyVaultManagedHardwareSecurityModule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module#resource_group_name DataAzurermKeyVaultManagedHardwareSecurityModule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module#timeouts DataAzurermKeyVaultManagedHardwareSecurityModule#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts;
}
export interface DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module#read DataAzurermKeyVaultManagedHardwareSecurityModule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsToTerraform(struct?: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsOutputReference | DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | undefined;
    set internalValue(value: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module azurerm_key_vault_managed_hardware_security_module}
*/
export declare class DataAzurermKeyVaultManagedHardwareSecurityModule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_managed_hardware_security_module";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module azurerm_key_vault_managed_hardware_security_module} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultManagedHardwareSecurityModuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultManagedHardwareSecurityModuleConfig);
    get adminObjectIds(): string[];
    get hsmUri(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get purgeProtectionEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get softDeleteRetentionDays(): number;
    tags(key: string): string | cdktf.IResolvable;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
