import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkServiceTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags#location DataAzurermNetworkServiceTags#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags#location_filter DataAzurermNetworkServiceTags#location_filter}
    */
    readonly locationFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags#service DataAzurermNetworkServiceTags#service}
    */
    readonly service: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags#timeouts DataAzurermNetworkServiceTags#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkServiceTagsTimeouts;
}
export interface DataAzurermNetworkServiceTagsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags#read DataAzurermNetworkServiceTags#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkServiceTagsTimeoutsToTerraform(struct?: DataAzurermNetworkServiceTagsTimeoutsOutputReference | DataAzurermNetworkServiceTagsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkServiceTagsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkServiceTagsTimeouts | undefined;
    set internalValue(value: DataAzurermNetworkServiceTagsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags azurerm_network_service_tags}
*/
export declare class DataAzurermNetworkServiceTags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_service_tags";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags azurerm_network_service_tags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkServiceTagsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkServiceTagsConfig);
    get addressPrefixes(): string[];
    get id(): string;
    get ipv4Cidrs(): string[];
    get ipv6Cidrs(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _locationFilter?;
    get locationFilter(): string;
    set locationFilter(value: string);
    resetLocationFilter(): void;
    get locationFilterInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNetworkServiceTagsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkServiceTagsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetworkServiceTagsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
