import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermProximityPlacementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#name DataAzurermProximityPlacementGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#resource_group_name DataAzurermProximityPlacementGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#timeouts DataAzurermProximityPlacementGroup#timeouts}
    */
    readonly timeouts?: DataAzurermProximityPlacementGroupTimeouts;
}
export interface DataAzurermProximityPlacementGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#read DataAzurermProximityPlacementGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermProximityPlacementGroupTimeoutsToTerraform(struct?: DataAzurermProximityPlacementGroupTimeoutsOutputReference | DataAzurermProximityPlacementGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermProximityPlacementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermProximityPlacementGroupTimeouts | undefined;
    set internalValue(value: DataAzurermProximityPlacementGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group azurerm_proximity_placement_group}
*/
export declare class DataAzurermProximityPlacementGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_proximity_placement_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group azurerm_proximity_placement_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermProximityPlacementGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermProximityPlacementGroupConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermProximityPlacementGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermProximityPlacementGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermProximityPlacementGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
