import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRecoveryServicesVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/recovery_services_vault#name DataAzurermRecoveryServicesVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/recovery_services_vault#resource_group_name DataAzurermRecoveryServicesVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/recovery_services_vault#timeouts DataAzurermRecoveryServicesVault#timeouts}
    */
    readonly timeouts?: DataAzurermRecoveryServicesVaultTimeouts;
}
export interface DataAzurermRecoveryServicesVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/recovery_services_vault#read DataAzurermRecoveryServicesVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRecoveryServicesVaultTimeoutsToTerraform(struct?: DataAzurermRecoveryServicesVaultTimeoutsOutputReference | DataAzurermRecoveryServicesVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRecoveryServicesVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermRecoveryServicesVaultTimeouts | undefined;
    set internalValue(value: DataAzurermRecoveryServicesVaultTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/recovery_services_vault azurerm_recovery_services_vault}
*/
export declare class DataAzurermRecoveryServicesVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_recovery_services_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/recovery_services_vault azurerm_recovery_services_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRecoveryServicesVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRecoveryServicesVaultConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermRecoveryServicesVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRecoveryServicesVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermRecoveryServicesVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
