import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#name DataAzurermServicebusSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#namespace_name DataAzurermServicebusSubscription#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#resource_group_name DataAzurermServicebusSubscription#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#topic_id DataAzurermServicebusSubscription#topic_id}
    */
    readonly topicId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#topic_name DataAzurermServicebusSubscription#topic_name}
    */
    readonly topicName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#timeouts DataAzurermServicebusSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusSubscriptionTimeouts;
}
export interface DataAzurermServicebusSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription#read DataAzurermServicebusSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusSubscriptionTimeoutsToTerraform(struct?: DataAzurermServicebusSubscriptionTimeoutsOutputReference | DataAzurermServicebusSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermServicebusSubscriptionTimeouts | undefined;
    set internalValue(value: DataAzurermServicebusSubscriptionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription azurerm_servicebus_subscription}
*/
export declare class DataAzurermServicebusSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_servicebus_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription azurerm_servicebus_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusSubscriptionConfig);
    get autoDeleteOnIdle(): string;
    get deadLetteringOnFilterEvaluationError(): cdktf.IResolvable;
    get deadLetteringOnMessageExpiration(): cdktf.IResolvable;
    get defaultMessageTtl(): string;
    get enableBatchedOperations(): cdktf.IResolvable;
    get forwardDeadLetteredMessagesTo(): string;
    get forwardTo(): string;
    get id(): string;
    get lockDuration(): string;
    get maxDeliveryCount(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get requiresSession(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    resetTopicId(): void;
    get topicIdInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    resetTopicName(): void;
    get topicNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermServicebusSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermServicebusSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
