import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageBlobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob#metadata DataAzurermStorageBlob#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob#name DataAzurermStorageBlob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob#storage_account_name DataAzurermStorageBlob#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob#storage_container_name DataAzurermStorageBlob#storage_container_name}
    */
    readonly storageContainerName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob#timeouts DataAzurermStorageBlob#timeouts}
    */
    readonly timeouts?: DataAzurermStorageBlobTimeouts;
}
export interface DataAzurermStorageBlobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob#read DataAzurermStorageBlob#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageBlobTimeoutsToTerraform(struct?: DataAzurermStorageBlobTimeoutsOutputReference | DataAzurermStorageBlobTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageBlobTimeouts | undefined;
    set internalValue(value: DataAzurermStorageBlobTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob azurerm_storage_blob}
*/
export declare class DataAzurermStorageBlob extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_blob";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_blob azurerm_storage_blob} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageBlobConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageBlobConfig);
    get accessTier(): string;
    get contentMd5(): string;
    get contentType(): string;
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _storageContainerName?;
    get storageContainerName(): string;
    set storageContainerName(value: string);
    get storageContainerNameInput(): string | undefined;
    get type(): string;
    get url(): string;
    private _timeouts;
    get timeouts(): DataAzurermStorageBlobTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageBlobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageBlobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
