import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermUserAssignedIdentityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity#name DataAzurermUserAssignedIdentity#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity#resource_group_name DataAzurermUserAssignedIdentity#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity#timeouts DataAzurermUserAssignedIdentity#timeouts}
    */
    readonly timeouts?: DataAzurermUserAssignedIdentityTimeouts;
}
export interface DataAzurermUserAssignedIdentityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity#read DataAzurermUserAssignedIdentity#read}
    */
    readonly read?: string;
}
export declare function dataAzurermUserAssignedIdentityTimeoutsToTerraform(struct?: DataAzurermUserAssignedIdentityTimeoutsOutputReference | DataAzurermUserAssignedIdentityTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermUserAssignedIdentityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermUserAssignedIdentityTimeouts | undefined;
    set internalValue(value: DataAzurermUserAssignedIdentityTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity azurerm_user_assigned_identity}
*/
export declare class DataAzurermUserAssignedIdentity extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_user_assigned_identity";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/user_assigned_identity azurerm_user_assigned_identity} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermUserAssignedIdentityConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermUserAssignedIdentityConfig);
    get clientId(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get principalId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermUserAssignedIdentityTimeoutsOutputReference;
    putTimeouts(value: DataAzurermUserAssignedIdentityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermUserAssignedIdentityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
