import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#name DataAzurermVirtualNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#resource_group_name DataAzurermVirtualNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#timeouts DataAzurermVirtualNetwork#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualNetworkTimeouts;
}
export interface DataAzurermVirtualNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#read DataAzurermVirtualNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkTimeoutsOutputReference | DataAzurermVirtualNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualNetworkTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualNetworkTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network azurerm_virtual_network}
*/
export declare class DataAzurermVirtualNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_network";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network azurerm_virtual_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkConfig);
    get addressSpace(): string[];
    get dnsServers(): string[];
    get guid(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subnets(): string[];
    tags(key: string): string | cdktf.IResolvable;
    vnetPeerings(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermVirtualNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
