import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskPoolIscsiTargetLunConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#disk_pool_managed_disk_attachment_id DiskPoolIscsiTargetLun#disk_pool_managed_disk_attachment_id}
    */
    readonly diskPoolManagedDiskAttachmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#iscsi_target_id DiskPoolIscsiTargetLun#iscsi_target_id}
    */
    readonly iscsiTargetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#name DiskPoolIscsiTargetLun#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#timeouts DiskPoolIscsiTargetLun#timeouts}
    */
    readonly timeouts?: DiskPoolIscsiTargetLunTimeouts;
}
export interface DiskPoolIscsiTargetLunTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#create DiskPoolIscsiTargetLun#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#delete DiskPoolIscsiTargetLun#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun#read DiskPoolIscsiTargetLun#read}
    */
    readonly read?: string;
}
export declare function diskPoolIscsiTargetLunTimeoutsToTerraform(struct?: DiskPoolIscsiTargetLunTimeoutsOutputReference | DiskPoolIscsiTargetLunTimeouts | cdktf.IResolvable): any;
export declare class DiskPoolIscsiTargetLunTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DiskPoolIscsiTargetLunTimeouts | undefined;
    set internalValue(value: DiskPoolIscsiTargetLunTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun azurerm_disk_pool_iscsi_target_lun}
*/
export declare class DiskPoolIscsiTargetLun extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_disk_pool_iscsi_target_lun";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target_lun azurerm_disk_pool_iscsi_target_lun} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskPoolIscsiTargetLunConfig
    */
    constructor(scope: Construct, id: string, config: DiskPoolIscsiTargetLunConfig);
    private _diskPoolManagedDiskAttachmentId?;
    get diskPoolManagedDiskAttachmentId(): string;
    set diskPoolManagedDiskAttachmentId(value: string);
    get diskPoolManagedDiskAttachmentIdInput(): string | undefined;
    get id(): string;
    private _iscsiTargetId?;
    get iscsiTargetId(): string;
    set iscsiTargetId(value: string);
    get iscsiTargetIdInput(): string | undefined;
    get lun(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DiskPoolIscsiTargetLunTimeoutsOutputReference;
    putTimeouts(value: DiskPoolIscsiTargetLunTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DiskPoolIscsiTargetLunTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
