import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskPoolManagedDiskAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment#disk_pool_id DiskPoolManagedDiskAttachment#disk_pool_id}
    */
    readonly diskPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment#managed_disk_id DiskPoolManagedDiskAttachment#managed_disk_id}
    */
    readonly managedDiskId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment#timeouts DiskPoolManagedDiskAttachment#timeouts}
    */
    readonly timeouts?: DiskPoolManagedDiskAttachmentTimeouts;
}
export interface DiskPoolManagedDiskAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment#create DiskPoolManagedDiskAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment#delete DiskPoolManagedDiskAttachment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment#read DiskPoolManagedDiskAttachment#read}
    */
    readonly read?: string;
}
export declare function diskPoolManagedDiskAttachmentTimeoutsToTerraform(struct?: DiskPoolManagedDiskAttachmentTimeoutsOutputReference | DiskPoolManagedDiskAttachmentTimeouts | cdktf.IResolvable): any;
export declare class DiskPoolManagedDiskAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DiskPoolManagedDiskAttachmentTimeouts | undefined;
    set internalValue(value: DiskPoolManagedDiskAttachmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment azurerm_disk_pool_managed_disk_attachment}
*/
export declare class DiskPoolManagedDiskAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_disk_pool_managed_disk_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_managed_disk_attachment azurerm_disk_pool_managed_disk_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskPoolManagedDiskAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: DiskPoolManagedDiskAttachmentConfig);
    private _diskPoolId?;
    get diskPoolId(): string;
    set diskPoolId(value: string);
    get diskPoolIdInput(): string | undefined;
    get id(): string;
    private _managedDiskId?;
    get managedDiskId(): string;
    set managedDiskId(value: string);
    get managedDiskIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DiskPoolManagedDiskAttachmentTimeoutsOutputReference;
    putTimeouts(value: DiskPoolManagedDiskAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DiskPoolManagedDiskAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
