import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRouteCircuitConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#address_prefix_ipv4 ExpressRouteCircuitConnection#address_prefix_ipv4}
    */
    readonly addressPrefixIpv4: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#address_prefix_ipv6 ExpressRouteCircuitConnection#address_prefix_ipv6}
    */
    readonly addressPrefixIpv6?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#authorization_key ExpressRouteCircuitConnection#authorization_key}
    */
    readonly authorizationKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#name ExpressRouteCircuitConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#peer_peering_id ExpressRouteCircuitConnection#peer_peering_id}
    */
    readonly peerPeeringId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#peering_id ExpressRouteCircuitConnection#peering_id}
    */
    readonly peeringId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#timeouts ExpressRouteCircuitConnection#timeouts}
    */
    readonly timeouts?: ExpressRouteCircuitConnectionTimeouts;
}
export interface ExpressRouteCircuitConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#create ExpressRouteCircuitConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#delete ExpressRouteCircuitConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#read ExpressRouteCircuitConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection#update ExpressRouteCircuitConnection#update}
    */
    readonly update?: string;
}
export declare function expressRouteCircuitConnectionTimeoutsToTerraform(struct?: ExpressRouteCircuitConnectionTimeoutsOutputReference | ExpressRouteCircuitConnectionTimeouts | cdktf.IResolvable): any;
export declare class ExpressRouteCircuitConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitConnectionTimeouts | undefined;
    set internalValue(value: ExpressRouteCircuitConnectionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection azurerm_express_route_circuit_connection}
*/
export declare class ExpressRouteCircuitConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_express_route_circuit_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection azurerm_express_route_circuit_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRouteCircuitConnectionConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitConnectionConfig);
    private _addressPrefixIpv4?;
    get addressPrefixIpv4(): string;
    set addressPrefixIpv4(value: string);
    get addressPrefixIpv4Input(): string | undefined;
    private _addressPrefixIpv6?;
    get addressPrefixIpv6(): string;
    set addressPrefixIpv6(value: string);
    resetAddressPrefixIpv6(): void;
    get addressPrefixIpv6Input(): string | undefined;
    private _authorizationKey?;
    get authorizationKey(): string;
    set authorizationKey(value: string);
    resetAuthorizationKey(): void;
    get authorizationKeyInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerPeeringId?;
    get peerPeeringId(): string;
    set peerPeeringId(value: string);
    get peerPeeringIdInput(): string | undefined;
    private _peeringId?;
    get peeringId(): string;
    set peeringId(value: string);
    get peeringIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ExpressRouteCircuitConnectionTimeoutsOutputReference;
    putTimeouts(value: ExpressRouteCircuitConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ExpressRouteCircuitConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
