import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FrontdoorRulesEngineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#enabled FrontdoorRulesEngine#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#frontdoor_name FrontdoorRulesEngine#frontdoor_name}
    */
    readonly frontdoorName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#name FrontdoorRulesEngine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#resource_group_name FrontdoorRulesEngine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#rule FrontdoorRulesEngine#rule}
    */
    readonly rule?: FrontdoorRulesEngineRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#timeouts FrontdoorRulesEngine#timeouts}
    */
    readonly timeouts?: FrontdoorRulesEngineTimeouts;
}
export interface FrontdoorRulesEngineRuleActionRequestHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#header_action_type FrontdoorRulesEngine#header_action_type}
    */
    readonly headerActionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#header_name FrontdoorRulesEngine#header_name}
    */
    readonly headerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#value FrontdoorRulesEngine#value}
    */
    readonly value?: string;
}
export declare function frontdoorRulesEngineRuleActionRequestHeaderToTerraform(struct?: FrontdoorRulesEngineRuleActionRequestHeader | cdktf.IResolvable): any;
export interface FrontdoorRulesEngineRuleActionResponseHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#header_action_type FrontdoorRulesEngine#header_action_type}
    */
    readonly headerActionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#header_name FrontdoorRulesEngine#header_name}
    */
    readonly headerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#value FrontdoorRulesEngine#value}
    */
    readonly value?: string;
}
export declare function frontdoorRulesEngineRuleActionResponseHeaderToTerraform(struct?: FrontdoorRulesEngineRuleActionResponseHeader | cdktf.IResolvable): any;
export interface FrontdoorRulesEngineRuleAction {
    /**
    * request_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#request_header FrontdoorRulesEngine#request_header}
    */
    readonly requestHeader?: FrontdoorRulesEngineRuleActionRequestHeader[] | cdktf.IResolvable;
    /**
    * response_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#response_header FrontdoorRulesEngine#response_header}
    */
    readonly responseHeader?: FrontdoorRulesEngineRuleActionResponseHeader[] | cdktf.IResolvable;
}
export declare function frontdoorRulesEngineRuleActionToTerraform(struct?: FrontdoorRulesEngineRuleActionOutputReference | FrontdoorRulesEngineRuleAction): any;
export declare class FrontdoorRulesEngineRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRulesEngineRuleAction | undefined;
    set internalValue(value: FrontdoorRulesEngineRuleAction | undefined);
    private _requestHeader?;
    get requestHeader(): FrontdoorRulesEngineRuleActionRequestHeader[] | cdktf.IResolvable;
    set requestHeader(value: FrontdoorRulesEngineRuleActionRequestHeader[] | cdktf.IResolvable);
    resetRequestHeader(): void;
    get requestHeaderInput(): cdktf.IResolvable | FrontdoorRulesEngineRuleActionRequestHeader[] | undefined;
    private _responseHeader?;
    get responseHeader(): FrontdoorRulesEngineRuleActionResponseHeader[] | cdktf.IResolvable;
    set responseHeader(value: FrontdoorRulesEngineRuleActionResponseHeader[] | cdktf.IResolvable);
    resetResponseHeader(): void;
    get responseHeaderInput(): cdktf.IResolvable | FrontdoorRulesEngineRuleActionResponseHeader[] | undefined;
}
export interface FrontdoorRulesEngineRuleMatchCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#negate_condition FrontdoorRulesEngine#negate_condition}
    */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#operator FrontdoorRulesEngine#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#selector FrontdoorRulesEngine#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#transform FrontdoorRulesEngine#transform}
    */
    readonly transform?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#value FrontdoorRulesEngine#value}
    */
    readonly value?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#variable FrontdoorRulesEngine#variable}
    */
    readonly variable?: string;
}
export declare function frontdoorRulesEngineRuleMatchConditionToTerraform(struct?: FrontdoorRulesEngineRuleMatchCondition | cdktf.IResolvable): any;
export interface FrontdoorRulesEngineRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#name FrontdoorRulesEngine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#priority FrontdoorRulesEngine#priority}
    */
    readonly priority: number;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#action FrontdoorRulesEngine#action}
    */
    readonly action?: FrontdoorRulesEngineRuleAction;
    /**
    * match_condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#match_condition FrontdoorRulesEngine#match_condition}
    */
    readonly matchCondition?: FrontdoorRulesEngineRuleMatchCondition[] | cdktf.IResolvable;
}
export declare function frontdoorRulesEngineRuleToTerraform(struct?: FrontdoorRulesEngineRule | cdktf.IResolvable): any;
export interface FrontdoorRulesEngineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#create FrontdoorRulesEngine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#delete FrontdoorRulesEngine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#read FrontdoorRulesEngine#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine#update FrontdoorRulesEngine#update}
    */
    readonly update?: string;
}
export declare function frontdoorRulesEngineTimeoutsToTerraform(struct?: FrontdoorRulesEngineTimeoutsOutputReference | FrontdoorRulesEngineTimeouts | cdktf.IResolvable): any;
export declare class FrontdoorRulesEngineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRulesEngineTimeouts | undefined;
    set internalValue(value: FrontdoorRulesEngineTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine azurerm_frontdoor_rules_engine}
*/
export declare class FrontdoorRulesEngine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_frontdoor_rules_engine";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine azurerm_frontdoor_rules_engine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorRulesEngineConfig
    */
    constructor(scope: Construct, id: string, config: FrontdoorRulesEngineConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frontdoorName?;
    get frontdoorName(): string;
    set frontdoorName(value: string);
    get frontdoorNameInput(): string | undefined;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule?;
    get rule(): FrontdoorRulesEngineRule[] | cdktf.IResolvable;
    set rule(value: FrontdoorRulesEngineRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | FrontdoorRulesEngineRule[] | undefined;
    private _timeouts;
    get timeouts(): FrontdoorRulesEngineTimeoutsOutputReference;
    putTimeouts(value: FrontdoorRulesEngineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FrontdoorRulesEngineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
