import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IotSecurityDeviceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#iothub_id IotSecurityDeviceGroup#iothub_id}
    */
    readonly iothubId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#name IotSecurityDeviceGroup#name}
    */
    readonly name: string;
    /**
    * allow_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#allow_rule IotSecurityDeviceGroup#allow_rule}
    */
    readonly allowRule?: IotSecurityDeviceGroupAllowRule;
    /**
    * range_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#range_rule IotSecurityDeviceGroup#range_rule}
    */
    readonly rangeRule?: IotSecurityDeviceGroupRangeRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#timeouts IotSecurityDeviceGroup#timeouts}
    */
    readonly timeouts?: IotSecurityDeviceGroupTimeouts;
}
export interface IotSecurityDeviceGroupAllowRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#connection_from_ips_not_allowed IotSecurityDeviceGroup#connection_from_ips_not_allowed}
    */
    readonly connectionFromIpsNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#connection_to_ip_not_allowed IotSecurityDeviceGroup#connection_to_ip_not_allowed}
    */
    readonly connectionToIpNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#connection_to_ips_not_allowed IotSecurityDeviceGroup#connection_to_ips_not_allowed}
    */
    readonly connectionToIpsNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#local_user_not_allowed IotSecurityDeviceGroup#local_user_not_allowed}
    */
    readonly localUserNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#local_users_not_allowed IotSecurityDeviceGroup#local_users_not_allowed}
    */
    readonly localUsersNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#process_not_allowed IotSecurityDeviceGroup#process_not_allowed}
    */
    readonly processNotAllowed?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#processes_not_allowed IotSecurityDeviceGroup#processes_not_allowed}
    */
    readonly processesNotAllowed?: string[];
}
export declare function iotSecurityDeviceGroupAllowRuleToTerraform(struct?: IotSecurityDeviceGroupAllowRuleOutputReference | IotSecurityDeviceGroupAllowRule): any;
export declare class IotSecurityDeviceGroupAllowRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotSecurityDeviceGroupAllowRule | undefined;
    set internalValue(value: IotSecurityDeviceGroupAllowRule | undefined);
    private _connectionFromIpsNotAllowed?;
    get connectionFromIpsNotAllowed(): string[];
    set connectionFromIpsNotAllowed(value: string[]);
    resetConnectionFromIpsNotAllowed(): void;
    get connectionFromIpsNotAllowedInput(): string[] | undefined;
    private _connectionToIpNotAllowed?;
    get connectionToIpNotAllowed(): string[];
    set connectionToIpNotAllowed(value: string[]);
    resetConnectionToIpNotAllowed(): void;
    get connectionToIpNotAllowedInput(): string[] | undefined;
    private _connectionToIpsNotAllowed?;
    get connectionToIpsNotAllowed(): string[];
    set connectionToIpsNotAllowed(value: string[]);
    resetConnectionToIpsNotAllowed(): void;
    get connectionToIpsNotAllowedInput(): string[] | undefined;
    private _localUserNotAllowed?;
    get localUserNotAllowed(): string[];
    set localUserNotAllowed(value: string[]);
    resetLocalUserNotAllowed(): void;
    get localUserNotAllowedInput(): string[] | undefined;
    private _localUsersNotAllowed?;
    get localUsersNotAllowed(): string[];
    set localUsersNotAllowed(value: string[]);
    resetLocalUsersNotAllowed(): void;
    get localUsersNotAllowedInput(): string[] | undefined;
    private _processNotAllowed?;
    get processNotAllowed(): string[];
    set processNotAllowed(value: string[]);
    resetProcessNotAllowed(): void;
    get processNotAllowedInput(): string[] | undefined;
    private _processesNotAllowed?;
    get processesNotAllowed(): string[];
    set processesNotAllowed(value: string[]);
    resetProcessesNotAllowed(): void;
    get processesNotAllowedInput(): string[] | undefined;
}
export interface IotSecurityDeviceGroupRangeRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#duration IotSecurityDeviceGroup#duration}
    */
    readonly duration: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#max IotSecurityDeviceGroup#max}
    */
    readonly max: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#min IotSecurityDeviceGroup#min}
    */
    readonly min: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#type IotSecurityDeviceGroup#type}
    */
    readonly type: string;
}
export declare function iotSecurityDeviceGroupRangeRuleToTerraform(struct?: IotSecurityDeviceGroupRangeRule | cdktf.IResolvable): any;
export interface IotSecurityDeviceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#create IotSecurityDeviceGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#delete IotSecurityDeviceGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#read IotSecurityDeviceGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group#update IotSecurityDeviceGroup#update}
    */
    readonly update?: string;
}
export declare function iotSecurityDeviceGroupTimeoutsToTerraform(struct?: IotSecurityDeviceGroupTimeoutsOutputReference | IotSecurityDeviceGroupTimeouts | cdktf.IResolvable): any;
export declare class IotSecurityDeviceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotSecurityDeviceGroupTimeouts | undefined;
    set internalValue(value: IotSecurityDeviceGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group azurerm_iot_security_device_group}
*/
export declare class IotSecurityDeviceGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iot_security_device_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_device_group azurerm_iot_security_device_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotSecurityDeviceGroupConfig
    */
    constructor(scope: Construct, id: string, config: IotSecurityDeviceGroupConfig);
    get id(): string;
    private _iothubId?;
    get iothubId(): string;
    set iothubId(value: string);
    get iothubIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _allowRule;
    get allowRule(): IotSecurityDeviceGroupAllowRuleOutputReference;
    putAllowRule(value: IotSecurityDeviceGroupAllowRule): void;
    resetAllowRule(): void;
    get allowRuleInput(): IotSecurityDeviceGroupAllowRule | undefined;
    private _rangeRule?;
    get rangeRule(): IotSecurityDeviceGroupRangeRule[] | cdktf.IResolvable;
    set rangeRule(value: IotSecurityDeviceGroupRangeRule[] | cdktf.IResolvable);
    resetRangeRule(): void;
    get rangeRuleInput(): cdktf.IResolvable | IotSecurityDeviceGroupRangeRule[] | undefined;
    private _timeouts;
    get timeouts(): IotSecurityDeviceGroupTimeoutsOutputReference;
    putTimeouts(value: IotSecurityDeviceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IotSecurityDeviceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
