import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KustoDatabasePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#client_id KustoDatabasePrincipal#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#cluster_name KustoDatabasePrincipal#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#database_name KustoDatabasePrincipal#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#object_id KustoDatabasePrincipal#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#resource_group_name KustoDatabasePrincipal#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#role KustoDatabasePrincipal#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#type KustoDatabasePrincipal#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#timeouts KustoDatabasePrincipal#timeouts}
    */
    readonly timeouts?: KustoDatabasePrincipalTimeouts;
}
export interface KustoDatabasePrincipalTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#create KustoDatabasePrincipal#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#delete KustoDatabasePrincipal#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#read KustoDatabasePrincipal#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal#update KustoDatabasePrincipal#update}
    */
    readonly update?: string;
}
export declare function kustoDatabasePrincipalTimeoutsToTerraform(struct?: KustoDatabasePrincipalTimeoutsOutputReference | KustoDatabasePrincipalTimeouts | cdktf.IResolvable): any;
export declare class KustoDatabasePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KustoDatabasePrincipalTimeouts | undefined;
    set internalValue(value: KustoDatabasePrincipalTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal azurerm_kusto_database_principal}
*/
export declare class KustoDatabasePrincipal extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kusto_database_principal";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal azurerm_kusto_database_principal} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KustoDatabasePrincipalConfig
    */
    constructor(scope: Construct, id: string, config: KustoDatabasePrincipalConfig);
    get appId(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    get email(): string;
    get fullyQualifiedName(): string;
    get id(): string;
    get name(): string;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): KustoDatabasePrincipalTimeoutsOutputReference;
    putTimeouts(value: KustoDatabasePrincipalTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KustoDatabasePrincipalTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
