import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MachineLearningComputeClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#description MachineLearningComputeCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#local_auth_enabled MachineLearningComputeCluster#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#location MachineLearningComputeCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#machine_learning_workspace_id MachineLearningComputeCluster#machine_learning_workspace_id}
    */
    readonly machineLearningWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#name MachineLearningComputeCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#ssh_public_access_enabled MachineLearningComputeCluster#ssh_public_access_enabled}
    */
    readonly sshPublicAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#subnet_resource_id MachineLearningComputeCluster#subnet_resource_id}
    */
    readonly subnetResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#tags MachineLearningComputeCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#vm_priority MachineLearningComputeCluster#vm_priority}
    */
    readonly vmPriority: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#vm_size MachineLearningComputeCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#identity MachineLearningComputeCluster#identity}
    */
    readonly identity?: MachineLearningComputeClusterIdentity;
    /**
    * scale_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#scale_settings MachineLearningComputeCluster#scale_settings}
    */
    readonly scaleSettings: MachineLearningComputeClusterScaleSettings;
    /**
    * ssh block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#ssh MachineLearningComputeCluster#ssh}
    */
    readonly ssh?: MachineLearningComputeClusterSsh;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#timeouts MachineLearningComputeCluster#timeouts}
    */
    readonly timeouts?: MachineLearningComputeClusterTimeouts;
}
export interface MachineLearningComputeClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#identity_ids MachineLearningComputeCluster#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#type MachineLearningComputeCluster#type}
    */
    readonly type: string;
}
export declare function machineLearningComputeClusterIdentityToTerraform(struct?: MachineLearningComputeClusterIdentityOutputReference | MachineLearningComputeClusterIdentity): any;
export declare class MachineLearningComputeClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeClusterIdentity | undefined;
    set internalValue(value: MachineLearningComputeClusterIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MachineLearningComputeClusterScaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#max_node_count MachineLearningComputeCluster#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#min_node_count MachineLearningComputeCluster#min_node_count}
    */
    readonly minNodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#scale_down_nodes_after_idle_duration MachineLearningComputeCluster#scale_down_nodes_after_idle_duration}
    */
    readonly scaleDownNodesAfterIdleDuration: string;
}
export declare function machineLearningComputeClusterScaleSettingsToTerraform(struct?: MachineLearningComputeClusterScaleSettingsOutputReference | MachineLearningComputeClusterScaleSettings): any;
export declare class MachineLearningComputeClusterScaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeClusterScaleSettings | undefined;
    set internalValue(value: MachineLearningComputeClusterScaleSettings | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
    private _scaleDownNodesAfterIdleDuration?;
    get scaleDownNodesAfterIdleDuration(): string;
    set scaleDownNodesAfterIdleDuration(value: string);
    get scaleDownNodesAfterIdleDurationInput(): string | undefined;
}
export interface MachineLearningComputeClusterSsh {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#admin_password MachineLearningComputeCluster#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#admin_username MachineLearningComputeCluster#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#key_value MachineLearningComputeCluster#key_value}
    */
    readonly keyValue?: string;
}
export declare function machineLearningComputeClusterSshToTerraform(struct?: MachineLearningComputeClusterSshOutputReference | MachineLearningComputeClusterSsh): any;
export declare class MachineLearningComputeClusterSshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeClusterSsh | undefined;
    set internalValue(value: MachineLearningComputeClusterSsh | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _keyValue?;
    get keyValue(): string;
    set keyValue(value: string);
    resetKeyValue(): void;
    get keyValueInput(): string | undefined;
}
export interface MachineLearningComputeClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#create MachineLearningComputeCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#delete MachineLearningComputeCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster#read MachineLearningComputeCluster#read}
    */
    readonly read?: string;
}
export declare function machineLearningComputeClusterTimeoutsToTerraform(struct?: MachineLearningComputeClusterTimeoutsOutputReference | MachineLearningComputeClusterTimeouts | cdktf.IResolvable): any;
export declare class MachineLearningComputeClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningComputeClusterTimeouts | undefined;
    set internalValue(value: MachineLearningComputeClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster azurerm_machine_learning_compute_cluster}
*/
export declare class MachineLearningComputeCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_machine_learning_compute_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_cluster azurerm_machine_learning_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MachineLearningComputeClusterConfig
    */
    constructor(scope: Construct, id: string, config: MachineLearningComputeClusterConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    get machineLearningWorkspaceId(): string;
    set machineLearningWorkspaceId(value: string);
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sshPublicAccessEnabled?;
    get sshPublicAccessEnabled(): boolean | cdktf.IResolvable;
    set sshPublicAccessEnabled(value: boolean | cdktf.IResolvable);
    resetSshPublicAccessEnabled(): void;
    get sshPublicAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetResourceId?;
    get subnetResourceId(): string;
    set subnetResourceId(value: string);
    resetSubnetResourceId(): void;
    get subnetResourceIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vmPriority?;
    get vmPriority(): string;
    set vmPriority(value: string);
    get vmPriorityInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _identity;
    get identity(): MachineLearningComputeClusterIdentityOutputReference;
    putIdentity(value: MachineLearningComputeClusterIdentity): void;
    resetIdentity(): void;
    get identityInput(): MachineLearningComputeClusterIdentity | undefined;
    private _scaleSettings;
    get scaleSettings(): MachineLearningComputeClusterScaleSettingsOutputReference;
    putScaleSettings(value: MachineLearningComputeClusterScaleSettings): void;
    get scaleSettingsInput(): MachineLearningComputeClusterScaleSettings | undefined;
    private _ssh;
    get ssh(): MachineLearningComputeClusterSshOutputReference;
    putSsh(value: MachineLearningComputeClusterSsh): void;
    resetSsh(): void;
    get sshInput(): MachineLearningComputeClusterSsh | undefined;
    private _timeouts;
    get timeouts(): MachineLearningComputeClusterTimeoutsOutputReference;
    putTimeouts(value: MachineLearningComputeClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MachineLearningComputeClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
