import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MariadbFirewallRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#end_ip_address MariadbFirewallRule#end_ip_address}
    */
    readonly endIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#name MariadbFirewallRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#resource_group_name MariadbFirewallRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#server_name MariadbFirewallRule#server_name}
    */
    readonly serverName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#start_ip_address MariadbFirewallRule#start_ip_address}
    */
    readonly startIpAddress: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#timeouts MariadbFirewallRule#timeouts}
    */
    readonly timeouts?: MariadbFirewallRuleTimeouts;
}
export interface MariadbFirewallRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#create MariadbFirewallRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#delete MariadbFirewallRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#read MariadbFirewallRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule#update MariadbFirewallRule#update}
    */
    readonly update?: string;
}
export declare function mariadbFirewallRuleTimeoutsToTerraform(struct?: MariadbFirewallRuleTimeoutsOutputReference | MariadbFirewallRuleTimeouts | cdktf.IResolvable): any;
export declare class MariadbFirewallRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MariadbFirewallRuleTimeouts | undefined;
    set internalValue(value: MariadbFirewallRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule azurerm_mariadb_firewall_rule}
*/
export declare class MariadbFirewallRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mariadb_firewall_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mariadb_firewall_rule azurerm_mariadb_firewall_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MariadbFirewallRuleConfig
    */
    constructor(scope: Construct, id: string, config: MariadbFirewallRuleConfig);
    private _endIpAddress?;
    get endIpAddress(): string;
    set endIpAddress(value: string);
    get endIpAddressInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _startIpAddress?;
    get startIpAddress(): string;
    set startIpAddress(value: string);
    get startIpAddressInput(): string | undefined;
    private _timeouts;
    get timeouts(): MariadbFirewallRuleTimeoutsOutputReference;
    putTimeouts(value: MariadbFirewallRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MariadbFirewallRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
