import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MysqlServerKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#key_vault_key_id MysqlServerKey#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#server_id MysqlServerKey#server_id}
    */
    readonly serverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#timeouts MysqlServerKey#timeouts}
    */
    readonly timeouts?: MysqlServerKeyTimeouts;
}
export interface MysqlServerKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#create MysqlServerKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#delete MysqlServerKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#read MysqlServerKey#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key#update MysqlServerKey#update}
    */
    readonly update?: string;
}
export declare function mysqlServerKeyTimeoutsToTerraform(struct?: MysqlServerKeyTimeoutsOutputReference | MysqlServerKeyTimeouts | cdktf.IResolvable): any;
export declare class MysqlServerKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MysqlServerKeyTimeouts | undefined;
    set internalValue(value: MysqlServerKeyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key azurerm_mysql_server_key}
*/
export declare class MysqlServerKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mysql_server_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server_key azurerm_mysql_server_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MysqlServerKeyConfig
    */
    constructor(scope: Construct, id: string, config: MysqlServerKeyConfig);
    get id(): string;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): MysqlServerKeyTimeoutsOutputReference;
    putTimeouts(value: MysqlServerKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MysqlServerKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
