import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkInterfaceBackendAddressPoolAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#backend_address_pool_id NetworkInterfaceBackendAddressPoolAssociation#backend_address_pool_id}
    */
    readonly backendAddressPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#ip_configuration_name NetworkInterfaceBackendAddressPoolAssociation#ip_configuration_name}
    */
    readonly ipConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#network_interface_id NetworkInterfaceBackendAddressPoolAssociation#network_interface_id}
    */
    readonly networkInterfaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#timeouts NetworkInterfaceBackendAddressPoolAssociation#timeouts}
    */
    readonly timeouts?: NetworkInterfaceBackendAddressPoolAssociationTimeouts;
}
export interface NetworkInterfaceBackendAddressPoolAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#create NetworkInterfaceBackendAddressPoolAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#delete NetworkInterfaceBackendAddressPoolAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#read NetworkInterfaceBackendAddressPoolAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association#update NetworkInterfaceBackendAddressPoolAssociation#update}
    */
    readonly update?: string;
}
export declare function networkInterfaceBackendAddressPoolAssociationTimeoutsToTerraform(struct?: NetworkInterfaceBackendAddressPoolAssociationTimeoutsOutputReference | NetworkInterfaceBackendAddressPoolAssociationTimeouts | cdktf.IResolvable): any;
export declare class NetworkInterfaceBackendAddressPoolAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkInterfaceBackendAddressPoolAssociationTimeouts | undefined;
    set internalValue(value: NetworkInterfaceBackendAddressPoolAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association azurerm_network_interface_backend_address_pool_association}
*/
export declare class NetworkInterfaceBackendAddressPoolAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_interface_backend_address_pool_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_backend_address_pool_association azurerm_network_interface_backend_address_pool_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkInterfaceBackendAddressPoolAssociationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkInterfaceBackendAddressPoolAssociationConfig);
    private _backendAddressPoolId?;
    get backendAddressPoolId(): string;
    set backendAddressPoolId(value: string);
    get backendAddressPoolIdInput(): string | undefined;
    get id(): string;
    private _ipConfigurationName?;
    get ipConfigurationName(): string;
    set ipConfigurationName(value: string);
    get ipConfigurationNameInput(): string | undefined;
    private _networkInterfaceId?;
    get networkInterfaceId(): string;
    set networkInterfaceId(value: string);
    get networkInterfaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkInterfaceBackendAddressPoolAssociationTimeoutsOutputReference;
    putTimeouts(value: NetworkInterfaceBackendAddressPoolAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkInterfaceBackendAddressPoolAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
