import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkInterfaceSecurityGroupAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#network_interface_id NetworkInterfaceSecurityGroupAssociation#network_interface_id}
    */
    readonly networkInterfaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#network_security_group_id NetworkInterfaceSecurityGroupAssociation#network_security_group_id}
    */
    readonly networkSecurityGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#timeouts NetworkInterfaceSecurityGroupAssociation#timeouts}
    */
    readonly timeouts?: NetworkInterfaceSecurityGroupAssociationTimeouts;
}
export interface NetworkInterfaceSecurityGroupAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#create NetworkInterfaceSecurityGroupAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#delete NetworkInterfaceSecurityGroupAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#read NetworkInterfaceSecurityGroupAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association#update NetworkInterfaceSecurityGroupAssociation#update}
    */
    readonly update?: string;
}
export declare function networkInterfaceSecurityGroupAssociationTimeoutsToTerraform(struct?: NetworkInterfaceSecurityGroupAssociationTimeoutsOutputReference | NetworkInterfaceSecurityGroupAssociationTimeouts | cdktf.IResolvable): any;
export declare class NetworkInterfaceSecurityGroupAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkInterfaceSecurityGroupAssociationTimeouts | undefined;
    set internalValue(value: NetworkInterfaceSecurityGroupAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association azurerm_network_interface_security_group_association}
*/
export declare class NetworkInterfaceSecurityGroupAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_interface_security_group_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association azurerm_network_interface_security_group_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkInterfaceSecurityGroupAssociationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkInterfaceSecurityGroupAssociationConfig);
    get id(): string;
    private _networkInterfaceId?;
    get networkInterfaceId(): string;
    set networkInterfaceId(value: string);
    get networkInterfaceIdInput(): string | undefined;
    private _networkSecurityGroupId?;
    get networkSecurityGroupId(): string;
    set networkSecurityGroupId(value: string);
    get networkSecurityGroupIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkInterfaceSecurityGroupAssociationTimeoutsOutputReference;
    putTimeouts(value: NetworkInterfaceSecurityGroupAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkInterfaceSecurityGroupAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
