import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateDnsCnameRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#name PrivateDnsCnameRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#record PrivateDnsCnameRecord#record}
    */
    readonly record: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#resource_group_name PrivateDnsCnameRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#tags PrivateDnsCnameRecord#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#ttl PrivateDnsCnameRecord#ttl}
    */
    readonly ttl: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#zone_name PrivateDnsCnameRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#timeouts PrivateDnsCnameRecord#timeouts}
    */
    readonly timeouts?: PrivateDnsCnameRecordTimeouts;
}
export interface PrivateDnsCnameRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#create PrivateDnsCnameRecord#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#delete PrivateDnsCnameRecord#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#read PrivateDnsCnameRecord#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record#update PrivateDnsCnameRecord#update}
    */
    readonly update?: string;
}
export declare function privateDnsCnameRecordTimeoutsToTerraform(struct?: PrivateDnsCnameRecordTimeoutsOutputReference | PrivateDnsCnameRecordTimeouts | cdktf.IResolvable): any;
export declare class PrivateDnsCnameRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateDnsCnameRecordTimeouts | undefined;
    set internalValue(value: PrivateDnsCnameRecordTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record azurerm_private_dns_cname_record}
*/
export declare class PrivateDnsCnameRecord extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_private_dns_cname_record";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_cname_record azurerm_private_dns_cname_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateDnsCnameRecordConfig
    */
    constructor(scope: Construct, id: string, config: PrivateDnsCnameRecordConfig);
    get fqdn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _record?;
    get record(): string;
    set record(value: string);
    get recordInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): PrivateDnsCnameRecordTimeoutsOutputReference;
    putTimeouts(value: PrivateDnsCnameRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivateDnsCnameRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
