import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceFabricMeshApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#location ServiceFabricMeshApplication#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#name ServiceFabricMeshApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#resource_group_name ServiceFabricMeshApplication#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#tags ServiceFabricMeshApplication#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#service ServiceFabricMeshApplication#service}
    */
    readonly service: ServiceFabricMeshApplicationService[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#timeouts ServiceFabricMeshApplication#timeouts}
    */
    readonly timeouts?: ServiceFabricMeshApplicationTimeouts;
}
export interface ServiceFabricMeshApplicationServiceCodePackageResourcesLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#cpu ServiceFabricMeshApplication#cpu}
    */
    readonly cpu: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#memory ServiceFabricMeshApplication#memory}
    */
    readonly memory: number;
}
export declare function serviceFabricMeshApplicationServiceCodePackageResourcesLimitsToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackageResourcesLimitsOutputReference | ServiceFabricMeshApplicationServiceCodePackageResourcesLimits): any;
export declare class ServiceFabricMeshApplicationServiceCodePackageResourcesLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricMeshApplicationServiceCodePackageResourcesLimits | undefined;
    set internalValue(value: ServiceFabricMeshApplicationServiceCodePackageResourcesLimits | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    get cpuInput(): number | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    get memoryInput(): number | undefined;
}
export interface ServiceFabricMeshApplicationServiceCodePackageResourcesRequests {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#cpu ServiceFabricMeshApplication#cpu}
    */
    readonly cpu: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#memory ServiceFabricMeshApplication#memory}
    */
    readonly memory: number;
}
export declare function serviceFabricMeshApplicationServiceCodePackageResourcesRequestsToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackageResourcesRequestsOutputReference | ServiceFabricMeshApplicationServiceCodePackageResourcesRequests): any;
export declare class ServiceFabricMeshApplicationServiceCodePackageResourcesRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricMeshApplicationServiceCodePackageResourcesRequests | undefined;
    set internalValue(value: ServiceFabricMeshApplicationServiceCodePackageResourcesRequests | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    get cpuInput(): number | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    get memoryInput(): number | undefined;
}
export interface ServiceFabricMeshApplicationServiceCodePackageResources {
    /**
    * limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#limits ServiceFabricMeshApplication#limits}
    */
    readonly limits?: ServiceFabricMeshApplicationServiceCodePackageResourcesLimits;
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#requests ServiceFabricMeshApplication#requests}
    */
    readonly requests: ServiceFabricMeshApplicationServiceCodePackageResourcesRequests;
}
export declare function serviceFabricMeshApplicationServiceCodePackageResourcesToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackageResourcesOutputReference | ServiceFabricMeshApplicationServiceCodePackageResources): any;
export declare class ServiceFabricMeshApplicationServiceCodePackageResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricMeshApplicationServiceCodePackageResources | undefined;
    set internalValue(value: ServiceFabricMeshApplicationServiceCodePackageResources | undefined);
    private _limits;
    get limits(): ServiceFabricMeshApplicationServiceCodePackageResourcesLimitsOutputReference;
    putLimits(value: ServiceFabricMeshApplicationServiceCodePackageResourcesLimits): void;
    resetLimits(): void;
    get limitsInput(): ServiceFabricMeshApplicationServiceCodePackageResourcesLimits | undefined;
    private _requests;
    get requests(): ServiceFabricMeshApplicationServiceCodePackageResourcesRequestsOutputReference;
    putRequests(value: ServiceFabricMeshApplicationServiceCodePackageResourcesRequests): void;
    get requestsInput(): ServiceFabricMeshApplicationServiceCodePackageResourcesRequests | undefined;
}
export interface ServiceFabricMeshApplicationServiceCodePackage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#image_name ServiceFabricMeshApplication#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#name ServiceFabricMeshApplication#name}
    */
    readonly name: string;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#resources ServiceFabricMeshApplication#resources}
    */
    readonly resources: ServiceFabricMeshApplicationServiceCodePackageResources;
}
export declare function serviceFabricMeshApplicationServiceCodePackageToTerraform(struct?: ServiceFabricMeshApplicationServiceCodePackage | cdktf.IResolvable): any;
export interface ServiceFabricMeshApplicationService {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#name ServiceFabricMeshApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#os_type ServiceFabricMeshApplication#os_type}
    */
    readonly osType: string;
    /**
    * code_package block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#code_package ServiceFabricMeshApplication#code_package}
    */
    readonly codePackage: ServiceFabricMeshApplicationServiceCodePackage[] | cdktf.IResolvable;
}
export declare function serviceFabricMeshApplicationServiceToTerraform(struct?: ServiceFabricMeshApplicationService | cdktf.IResolvable): any;
export interface ServiceFabricMeshApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#create ServiceFabricMeshApplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#delete ServiceFabricMeshApplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#read ServiceFabricMeshApplication#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application#update ServiceFabricMeshApplication#update}
    */
    readonly update?: string;
}
export declare function serviceFabricMeshApplicationTimeoutsToTerraform(struct?: ServiceFabricMeshApplicationTimeoutsOutputReference | ServiceFabricMeshApplicationTimeouts | cdktf.IResolvable): any;
export declare class ServiceFabricMeshApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricMeshApplicationTimeouts | undefined;
    set internalValue(value: ServiceFabricMeshApplicationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application azurerm_service_fabric_mesh_application}
*/
export declare class ServiceFabricMeshApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_service_fabric_mesh_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_application azurerm_service_fabric_mesh_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceFabricMeshApplicationConfig
    */
    constructor(scope: Construct, id: string, config: ServiceFabricMeshApplicationConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _service?;
    get service(): ServiceFabricMeshApplicationService[] | cdktf.IResolvable;
    set service(value: ServiceFabricMeshApplicationService[] | cdktf.IResolvable);
    get serviceInput(): cdktf.IResolvable | ServiceFabricMeshApplicationService[] | undefined;
    private _timeouts;
    get timeouts(): ServiceFabricMeshApplicationTimeoutsOutputReference;
    putTimeouts(value: ServiceFabricMeshApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServiceFabricMeshApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
