import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceFabricMeshSecretValueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#location ServiceFabricMeshSecretValue#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#name ServiceFabricMeshSecretValue#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#service_fabric_mesh_secret_id ServiceFabricMeshSecretValue#service_fabric_mesh_secret_id}
    */
    readonly serviceFabricMeshSecretId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#tags ServiceFabricMeshSecretValue#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#value ServiceFabricMeshSecretValue#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#timeouts ServiceFabricMeshSecretValue#timeouts}
    */
    readonly timeouts?: ServiceFabricMeshSecretValueTimeouts;
}
export interface ServiceFabricMeshSecretValueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#create ServiceFabricMeshSecretValue#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#delete ServiceFabricMeshSecretValue#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#read ServiceFabricMeshSecretValue#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value#update ServiceFabricMeshSecretValue#update}
    */
    readonly update?: string;
}
export declare function serviceFabricMeshSecretValueTimeoutsToTerraform(struct?: ServiceFabricMeshSecretValueTimeoutsOutputReference | ServiceFabricMeshSecretValueTimeouts | cdktf.IResolvable): any;
export declare class ServiceFabricMeshSecretValueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricMeshSecretValueTimeouts | undefined;
    set internalValue(value: ServiceFabricMeshSecretValueTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value azurerm_service_fabric_mesh_secret_value}
*/
export declare class ServiceFabricMeshSecretValue extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_service_fabric_mesh_secret_value";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_mesh_secret_value azurerm_service_fabric_mesh_secret_value} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceFabricMeshSecretValueConfig
    */
    constructor(scope: Construct, id: string, config: ServiceFabricMeshSecretValueConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serviceFabricMeshSecretId?;
    get serviceFabricMeshSecretId(): string;
    set serviceFabricMeshSecretId(value: string);
    get serviceFabricMeshSecretIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServiceFabricMeshSecretValueTimeoutsOutputReference;
    putTimeouts(value: ServiceFabricMeshSecretValueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServiceFabricMeshSecretValueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
