import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlManagedDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#location SqlManagedDatabase#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#name SqlManagedDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#sql_managed_instance_id SqlManagedDatabase#sql_managed_instance_id}
    */
    readonly sqlManagedInstanceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#timeouts SqlManagedDatabase#timeouts}
    */
    readonly timeouts?: SqlManagedDatabaseTimeouts;
}
export interface SqlManagedDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#create SqlManagedDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#delete SqlManagedDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#read SqlManagedDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database#update SqlManagedDatabase#update}
    */
    readonly update?: string;
}
export declare function sqlManagedDatabaseTimeoutsToTerraform(struct?: SqlManagedDatabaseTimeoutsOutputReference | SqlManagedDatabaseTimeouts | cdktf.IResolvable): any;
export declare class SqlManagedDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlManagedDatabaseTimeouts | undefined;
    set internalValue(value: SqlManagedDatabaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database azurerm_sql_managed_database}
*/
export declare class SqlManagedDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sql_managed_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_managed_database azurerm_sql_managed_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlManagedDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: SqlManagedDatabaseConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sqlManagedInstanceId?;
    get sqlManagedInstanceId(): string;
    set sqlManagedInstanceId(value: string);
    get sqlManagedInstanceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SqlManagedDatabaseTimeoutsOutputReference;
    putTimeouts(value: SqlManagedDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SqlManagedDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
