import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionCostManagementExportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#active SubscriptionCostManagementExport#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#name SubscriptionCostManagementExport#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#recurrence_period_end_date SubscriptionCostManagementExport#recurrence_period_end_date}
    */
    readonly recurrencePeriodEndDate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#recurrence_period_start_date SubscriptionCostManagementExport#recurrence_period_start_date}
    */
    readonly recurrencePeriodStartDate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#recurrence_type SubscriptionCostManagementExport#recurrence_type}
    */
    readonly recurrenceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#subscription_id SubscriptionCostManagementExport#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * export_data_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#export_data_options SubscriptionCostManagementExport#export_data_options}
    */
    readonly exportDataOptions: SubscriptionCostManagementExportExportDataOptions;
    /**
    * export_data_storage_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#export_data_storage_location SubscriptionCostManagementExport#export_data_storage_location}
    */
    readonly exportDataStorageLocation: SubscriptionCostManagementExportExportDataStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#timeouts SubscriptionCostManagementExport#timeouts}
    */
    readonly timeouts?: SubscriptionCostManagementExportTimeouts;
}
export interface SubscriptionCostManagementExportExportDataOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#time_frame SubscriptionCostManagementExport#time_frame}
    */
    readonly timeFrame: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#type SubscriptionCostManagementExport#type}
    */
    readonly type: string;
}
export declare function subscriptionCostManagementExportExportDataOptionsToTerraform(struct?: SubscriptionCostManagementExportExportDataOptionsOutputReference | SubscriptionCostManagementExportExportDataOptions): any;
export declare class SubscriptionCostManagementExportExportDataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionCostManagementExportExportDataOptions | undefined;
    set internalValue(value: SubscriptionCostManagementExportExportDataOptions | undefined);
    private _timeFrame?;
    get timeFrame(): string;
    set timeFrame(value: string);
    get timeFrameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SubscriptionCostManagementExportExportDataStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#container_id SubscriptionCostManagementExport#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#root_folder_path SubscriptionCostManagementExport#root_folder_path}
    */
    readonly rootFolderPath: string;
}
export declare function subscriptionCostManagementExportExportDataStorageLocationToTerraform(struct?: SubscriptionCostManagementExportExportDataStorageLocationOutputReference | SubscriptionCostManagementExportExportDataStorageLocation): any;
export declare class SubscriptionCostManagementExportExportDataStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionCostManagementExportExportDataStorageLocation | undefined;
    set internalValue(value: SubscriptionCostManagementExportExportDataStorageLocation | undefined);
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _rootFolderPath?;
    get rootFolderPath(): string;
    set rootFolderPath(value: string);
    get rootFolderPathInput(): string | undefined;
}
export interface SubscriptionCostManagementExportTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#create SubscriptionCostManagementExport#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#delete SubscriptionCostManagementExport#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#read SubscriptionCostManagementExport#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export#update SubscriptionCostManagementExport#update}
    */
    readonly update?: string;
}
export declare function subscriptionCostManagementExportTimeoutsToTerraform(struct?: SubscriptionCostManagementExportTimeoutsOutputReference | SubscriptionCostManagementExportTimeouts | cdktf.IResolvable): any;
export declare class SubscriptionCostManagementExportTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionCostManagementExportTimeouts | undefined;
    set internalValue(value: SubscriptionCostManagementExportTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export azurerm_subscription_cost_management_export}
*/
export declare class SubscriptionCostManagementExport extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subscription_cost_management_export";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_cost_management_export azurerm_subscription_cost_management_export} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionCostManagementExportConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionCostManagementExportConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recurrencePeriodEndDate?;
    get recurrencePeriodEndDate(): string;
    set recurrencePeriodEndDate(value: string);
    get recurrencePeriodEndDateInput(): string | undefined;
    private _recurrencePeriodStartDate?;
    get recurrencePeriodStartDate(): string;
    set recurrencePeriodStartDate(value: string);
    get recurrencePeriodStartDateInput(): string | undefined;
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    get recurrenceTypeInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    private _exportDataOptions;
    get exportDataOptions(): SubscriptionCostManagementExportExportDataOptionsOutputReference;
    putExportDataOptions(value: SubscriptionCostManagementExportExportDataOptions): void;
    get exportDataOptionsInput(): SubscriptionCostManagementExportExportDataOptions | undefined;
    private _exportDataStorageLocation;
    get exportDataStorageLocation(): SubscriptionCostManagementExportExportDataStorageLocationOutputReference;
    putExportDataStorageLocation(value: SubscriptionCostManagementExportExportDataStorageLocation): void;
    get exportDataStorageLocationInput(): SubscriptionCostManagementExportExportDataStorageLocation | undefined;
    private _timeouts;
    get timeouts(): SubscriptionCostManagementExportTimeoutsOutputReference;
    putTimeouts(value: SubscriptionCostManagementExportTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubscriptionCostManagementExportTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
