import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerExternalEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#enabled TrafficManagerExternalEndpoint#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#endpoint_location TrafficManagerExternalEndpoint#endpoint_location}
    */
    readonly endpointLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#geo_mappings TrafficManagerExternalEndpoint#geo_mappings}
    */
    readonly geoMappings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#name TrafficManagerExternalEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#priority TrafficManagerExternalEndpoint#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#profile_id TrafficManagerExternalEndpoint#profile_id}
    */
    readonly profileId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#target TrafficManagerExternalEndpoint#target}
    */
    readonly target: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#weight TrafficManagerExternalEndpoint#weight}
    */
    readonly weight: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#custom_header TrafficManagerExternalEndpoint#custom_header}
    */
    readonly customHeader?: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#subnet TrafficManagerExternalEndpoint#subnet}
    */
    readonly subnet?: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#timeouts TrafficManagerExternalEndpoint#timeouts}
    */
    readonly timeouts?: TrafficManagerExternalEndpointTimeouts;
}
export interface TrafficManagerExternalEndpointCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#name TrafficManagerExternalEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#value TrafficManagerExternalEndpoint#value}
    */
    readonly value: string;
}
export declare function trafficManagerExternalEndpointCustomHeaderToTerraform(struct?: TrafficManagerExternalEndpointCustomHeader | cdktf.IResolvable): any;
export interface TrafficManagerExternalEndpointSubnet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#first TrafficManagerExternalEndpoint#first}
    */
    readonly first: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#last TrafficManagerExternalEndpoint#last}
    */
    readonly last?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#scope TrafficManagerExternalEndpoint#scope}
    */
    readonly scope?: number;
}
export declare function trafficManagerExternalEndpointSubnetToTerraform(struct?: TrafficManagerExternalEndpointSubnet | cdktf.IResolvable): any;
export interface TrafficManagerExternalEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#create TrafficManagerExternalEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#delete TrafficManagerExternalEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#read TrafficManagerExternalEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint#update TrafficManagerExternalEndpoint#update}
    */
    readonly update?: string;
}
export declare function trafficManagerExternalEndpointTimeoutsToTerraform(struct?: TrafficManagerExternalEndpointTimeoutsOutputReference | TrafficManagerExternalEndpointTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerExternalEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerExternalEndpointTimeouts | undefined;
    set internalValue(value: TrafficManagerExternalEndpointTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint azurerm_traffic_manager_external_endpoint}
*/
export declare class TrafficManagerExternalEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_traffic_manager_external_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_external_endpoint azurerm_traffic_manager_external_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerExternalEndpointConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerExternalEndpointConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointLocation?;
    get endpointLocation(): string;
    set endpointLocation(value: string);
    resetEndpointLocation(): void;
    get endpointLocationInput(): string | undefined;
    private _geoMappings?;
    get geoMappings(): string[];
    set geoMappings(value: string[]);
    resetGeoMappings(): void;
    get geoMappingsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _customHeader?;
    get customHeader(): TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable;
    set customHeader(value: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable);
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerExternalEndpointCustomHeader[] | undefined;
    private _subnet?;
    get subnet(): TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable;
    set subnet(value: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable);
    resetSubnet(): void;
    get subnetInput(): cdktf.IResolvable | TrafficManagerExternalEndpointSubnet[] | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerExternalEndpointTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerExternalEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): TrafficManagerExternalEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
