"""
    ODL-Info API

    Daten zur radioaktiven Belastung in Deutschland. Weitere Informationen unter https://odlinfo.bfs.de/ODL/DE/service/datenschnittstelle/datenschnittstelle_node.html.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: kontakt@bund.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from deutschland.strahlenschutz.exceptions import ApiAttributeError
from deutschland.strahlenschutz.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    OpenApiModel,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


def lazy_import():
    from deutschland.strahlenschutz.model.normal_feature_properties import (
        NormalFeatureProperties,
    )

    globals()["NormalFeatureProperties"] = NormalFeatureProperties


class ExtendedFeatureProperties(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ("site_status",): {
            "1": 1,
            "2": 2,
            "3": 3,
        },
        ("kid",): {
            "1": 1,
            "2": 2,
            "3": 3,
            "4": 4,
            "5": 5,
            "6": 6,
        },
        ("validated",): {
            "1": 1,
            "2": 2,
        },
        ("duration",): {
            "1H": "1h",
            "1D": "1d",
        },
    }

    validations = {}

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (
            bool,
            date,
            datetime,
            dict,
            float,
            int,
            list,
            str,
            none_type,
        )  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "site_status": (float,),  # noqa: E501
            "site_status_text": (str,),  # noqa: E501
            "kid": (float,),  # noqa: E501
            "height_above_sea": (float,),  # noqa: E501
            "value_cosmic": (float,),  # noqa: E501
            "value_terrestrial": (float,),  # noqa: E501
            "id": (str,),  # noqa: E501
            "kenn": (str,),  # noqa: E501
            "plz": (str,),  # noqa: E501
            "name": (str,),  # noqa: E501
            "start_measure": (datetime,),  # noqa: E501
            "end_measure": (datetime,),  # noqa: E501
            "value": (float,),  # noqa: E501
            "unit": (str,),  # noqa: E501
            "validated": (float,),  # noqa: E501
            "nuclide": (str,),  # noqa: E501
            "duration": (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    attribute_map = {
        "site_status": "site_status",  # noqa: E501
        "site_status_text": "site_status_text",  # noqa: E501
        "kid": "kid",  # noqa: E501
        "height_above_sea": "height_above_sea",  # noqa: E501
        "value_cosmic": "value_cosmic",  # noqa: E501
        "value_terrestrial": "value_terrestrial",  # noqa: E501
        "id": "id",  # noqa: E501
        "kenn": "kenn",  # noqa: E501
        "plz": "plz",  # noqa: E501
        "name": "name",  # noqa: E501
        "start_measure": "start_measure",  # noqa: E501
        "end_measure": "end_measure",  # noqa: E501
        "value": "value",  # noqa: E501
        "unit": "unit",  # noqa: E501
        "validated": "validated",  # noqa: E501
        "nuclide": "nuclide",  # noqa: E501
        "duration": "duration",  # noqa: E501
    }

    read_only_vars = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """ExtendedFeatureProperties - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            site_status (float): Status der Messstelle:   * `1` - In Betrieb   * `2` - Defekt   * `3` - Testbetrieb . [optional]  # noqa: E501
            site_status_text (str): Status der Messstelle als Text. [optional]  # noqa: E501
            kid (float): ID des Messnetzknotens, dem die Messstelle zugeordnet ist:   * `1` - Freiburg   * `2` - Berlin   * `3` - München   * `4` - Bonn   * `5` - Salzgitter   * `6` - Rendsburg . [optional]  # noqa: E501
            height_above_sea (float): Höhe der Messstelle über NN (Normal Null, Meereshöhe). [optional]  # noqa: E501
            value_cosmic (float): Kosmischer Anteil in `unit`. [optional]  # noqa: E501
            value_terrestrial (float): Terrestrischer Anteil in `unit`. [optional]  # noqa: E501
            id (str): Internationale ID der Messstelle. [optional]  # noqa: E501
            kenn (str): Interne Messstellenkennung. [optional]  # noqa: E501
            plz (str): PLZ der Messstelle. [optional]  # noqa: E501
            name (str): Name/Ortsname der Messstelle. [optional]  # noqa: E501
            start_measure (datetime): Startzeitpunkt der Messperiode für den gegebenen Messwert als ISO-Datetime. [optional]  # noqa: E501
            end_measure (datetime): Endzeitpunkt der Messperiode für den gegebenen Messwert als ISO-Datetime. [optional]  # noqa: E501
            value (float): Der Messwert in `unit` (setzt sich aus `value_cosmic` und `value_terrestrial` zusammen). [optional]  # noqa: E501
            unit (str): Einheit der Messwerte. [optional]  # noqa: E501
            validated (float): Prüfstatus des Messwertes:   * `1` - geprüft   * `2` - ungeprüft . [optional]  # noqa: E501
            nuclide (str): Bezeichnung der Messgröße. [optional]  # noqa: E501
            duration (str): Dauer der Messperiode   * `1h` - eine Stunde   * `1d` - ein Tag . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop("_check_type", True)
        _spec_property_naming = kwargs.pop("_spec_property_naming", False)
        _path_to_item = kwargs.pop("_path_to_item", ())
        _configuration = kwargs.pop("_configuration", None)
        _visited_composed_classes = kwargs.pop("_visited_composed_classes", ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments."
                % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            "_check_type": _check_type,
            "_path_to_item": _path_to_item,
            "_spec_property_naming": _spec_property_naming,
            "_configuration": _configuration,
            "_visited_composed_classes": self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if (
                var_name in discarded_args
                and self._configuration is not None
                and self._configuration.discard_unknown_keys
                and self._additional_properties_model_instances
            ):
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set(
        [
            "_data_store",
            "_check_type",
            "_spec_property_naming",
            "_path_to_item",
            "_configuration",
            "_visited_composed_classes",
            "_composed_instances",
            "_var_name_to_model_instances",
            "_additional_properties_model_instances",
        ]
    )

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ExtendedFeatureProperties - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            site_status (float): Status der Messstelle:   * `1` - In Betrieb   * `2` - Defekt   * `3` - Testbetrieb . [optional]  # noqa: E501
            site_status_text (str): Status der Messstelle als Text. [optional]  # noqa: E501
            kid (float): ID des Messnetzknotens, dem die Messstelle zugeordnet ist:   * `1` - Freiburg   * `2` - Berlin   * `3` - München   * `4` - Bonn   * `5` - Salzgitter   * `6` - Rendsburg . [optional]  # noqa: E501
            height_above_sea (float): Höhe der Messstelle über NN (Normal Null, Meereshöhe). [optional]  # noqa: E501
            value_cosmic (float): Kosmischer Anteil in `unit`. [optional]  # noqa: E501
            value_terrestrial (float): Terrestrischer Anteil in `unit`. [optional]  # noqa: E501
            id (str): Internationale ID der Messstelle. [optional]  # noqa: E501
            kenn (str): Interne Messstellenkennung. [optional]  # noqa: E501
            plz (str): PLZ der Messstelle. [optional]  # noqa: E501
            name (str): Name/Ortsname der Messstelle. [optional]  # noqa: E501
            start_measure (datetime): Startzeitpunkt der Messperiode für den gegebenen Messwert als ISO-Datetime. [optional]  # noqa: E501
            end_measure (datetime): Endzeitpunkt der Messperiode für den gegebenen Messwert als ISO-Datetime. [optional]  # noqa: E501
            value (float): Der Messwert in `unit` (setzt sich aus `value_cosmic` und `value_terrestrial` zusammen). [optional]  # noqa: E501
            unit (str): Einheit der Messwerte. [optional]  # noqa: E501
            validated (float): Prüfstatus des Messwertes:   * `1` - geprüft   * `2` - ungeprüft . [optional]  # noqa: E501
            nuclide (str): Bezeichnung der Messgröße. [optional]  # noqa: E501
            duration (str): Dauer der Messperiode   * `1h` - eine Stunde   * `1d` - ein Tag . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop("_check_type", True)
        _spec_property_naming = kwargs.pop("_spec_property_naming", False)
        _path_to_item = kwargs.pop("_path_to_item", ())
        _configuration = kwargs.pop("_configuration", None)
        _visited_composed_classes = kwargs.pop("_visited_composed_classes", ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments."
                % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            "_check_type": _check_type,
            "_path_to_item": _path_to_item,
            "_spec_property_naming": _spec_property_naming,
            "_configuration": _configuration,
            "_visited_composed_classes": self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if (
                var_name in discarded_args
                and self._configuration is not None
                and self._configuration.discard_unknown_keys
                and self._additional_properties_model_instances
            ):
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(
                    f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                    f"class with read only attributes."
                )

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
            "anyOf": [],
            "allOf": [
                NormalFeatureProperties,
            ],
            "oneOf": [],
        }
