# coding: utf-8

"""
    VIER Cognitive Voice Call API

    With the VIER Cognitive Voice Call API you can easily do things like building your voicebots, which can be reached via phone calls. You can receive speech input of the customer as transcripted text in many languages. Let different voices say your text in this call. After the voicebot dialog you may drop the call (call fully completed by bot) or transfer the call e.g. to the relevant service hotline (human agent required to satisfy customer).  On some events, such as receiving an incoming phone call or transcription of a customer's utterance, VIER makes an HTTP request to a URL to be provided by you. This is called a webhook. To handle a webhook, you need to build a small web application that can accept the HTTP requests. The required webhooks are listed as bot endpoints.  The operations defined in this specification can be used by your bot to trigger certain voice and/or telephony related actions on the currently active call.  Most of the available operations are subject to queuing, meaning that the commands, even when triggered simultaneously, will not be executed simultaneously. Instead, these operations will be executed after each other. This is being done to simplify bot development as otherwise the bot would need to hit exact timings for the operations it triggers to not produce overlapping audio in the phone and still be quick enough to feel responsive to the conversation partner.  The queuing mechanism allows the bot to simply trigger several operations after each other and CVG makes sure to to execute them without overlap after each other. Some operations also support a `bargeIn` flag, which makes the operation interruptible by the conversation partner.  All operations that are not subject to queuing will document this fact in their respective description.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from cvg_sdk import schemas  # noqa: F401


class OutboundCallFailure(
    schemas.ComposedSchema,
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        
        @staticmethod
        def discriminator():
            return {
                'status': {
                    'Failure': OutboundCallFailure,
                    'Success': OutboundCallSuccess,
                }
            }
        
        
        class all_of_1(
            schemas.DictSchema
        ):
        
        
            class MetaOapg:
                required = {
                    "reason",
                    "message",
                }
                
                class properties:
                    ringStartTimestamp = schemas.Int64Schema
                    
                    
                    class reason(
                        schemas.EnumBase,
                        schemas.StrSchema
                    ):
                    
                    
                        class MetaOapg:
                            enum_value_to_name = {
                                "ALREADY_BRIDGED": "ALREADY_BRIDGED",
                                "ANSWERING_MACHINE": "ANSWERING_MACHINE",
                                "BOT_CALL_ENDED_WHILE_DIALING": "BOT_CALL_ENDED_WHILE_DIALING",
                                "DESTINATION_BLOCKED": "DESTINATION_BLOCKED",
                                "DISABLED": "DISABLED",
                                "HEAD_NUMBER_EXTENSIONS_EXHAUSTED": "HEAD_NUMBER_EXTENSIONS_EXHAUSTED",
                                "PROJECT_NOT_FOUND": "PROJECT_NOT_FOUND",
                                "RATE_LIMITED": "RATE_LIMITED",
                                "REJECTED": "REJECTED",
                                "RESELLER_NOT_FOUND": "RESELLER_NOT_FOUND",
                                "RING_TIMED_OUT": "RING_TIMED_OUT",
                                "MISSING_CALLER_ID": "MISSING_CALLER_ID",
                                "UNKNOWN": "UNKNOWN",
                            }
                        
                        @schemas.classproperty
                        def ALREADY_BRIDGED(cls):
                            return cls("ALREADY_BRIDGED")
                        
                        @schemas.classproperty
                        def ANSWERING_MACHINE(cls):
                            return cls("ANSWERING_MACHINE")
                        
                        @schemas.classproperty
                        def BOT_CALL_ENDED_WHILE_DIALING(cls):
                            return cls("BOT_CALL_ENDED_WHILE_DIALING")
                        
                        @schemas.classproperty
                        def DESTINATION_BLOCKED(cls):
                            return cls("DESTINATION_BLOCKED")
                        
                        @schemas.classproperty
                        def DISABLED(cls):
                            return cls("DISABLED")
                        
                        @schemas.classproperty
                        def HEAD_NUMBER_EXTENSIONS_EXHAUSTED(cls):
                            return cls("HEAD_NUMBER_EXTENSIONS_EXHAUSTED")
                        
                        @schemas.classproperty
                        def PROJECT_NOT_FOUND(cls):
                            return cls("PROJECT_NOT_FOUND")
                        
                        @schemas.classproperty
                        def RATE_LIMITED(cls):
                            return cls("RATE_LIMITED")
                        
                        @schemas.classproperty
                        def REJECTED(cls):
                            return cls("REJECTED")
                        
                        @schemas.classproperty
                        def RESELLER_NOT_FOUND(cls):
                            return cls("RESELLER_NOT_FOUND")
                        
                        @schemas.classproperty
                        def RING_TIMED_OUT(cls):
                            return cls("RING_TIMED_OUT")
                        
                        @schemas.classproperty
                        def MISSING_CALLER_ID(cls):
                            return cls("MISSING_CALLER_ID")
                        
                        @schemas.classproperty
                        def UNKNOWN(cls):
                            return cls("UNKNOWN")
                    message = schemas.StrSchema
                    __annotations__ = {
                        "ringStartTimestamp": ringStartTimestamp,
                        "reason": reason,
                        "message": message,
                    }
            
            reason: MetaOapg.properties.reason
            message: MetaOapg.properties.message
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["ringStartTimestamp"]) -> MetaOapg.properties.ringStartTimestamp: ...
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["reason"]) -> MetaOapg.properties.reason: ...
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["message"]) -> MetaOapg.properties.message: ...
            
            @typing.overload
            def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
            
            def __getitem__(self, name: typing.Union[typing_extensions.Literal["ringStartTimestamp", "reason", "message", ], str]):
                # dict_instance[name] accessor
                return super().__getitem__(name)
            
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["ringStartTimestamp"]) -> typing.Union[MetaOapg.properties.ringStartTimestamp, schemas.Unset]: ...
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["reason"]) -> MetaOapg.properties.reason: ...
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["message"]) -> MetaOapg.properties.message: ...
            
            @typing.overload
            def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
            
            def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["ringStartTimestamp", "reason", "message", ], str]):
                return super().get_item_oapg(name)
            
        
            def __new__(
                cls,
                *args: typing.Union[dict, frozendict.frozendict, ],
                reason: typing.Union[MetaOapg.properties.reason, str, ],
                message: typing.Union[MetaOapg.properties.message, str, ],
                ringStartTimestamp: typing.Union[MetaOapg.properties.ringStartTimestamp, decimal.Decimal, int, schemas.Unset] = schemas.unset,
                _configuration: typing.Optional[schemas.Configuration] = None,
                **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
            ) -> 'all_of_1':
                return super().__new__(
                    cls,
                    *args,
                    reason=reason,
                    message=message,
                    ringStartTimestamp=ringStartTimestamp,
                    _configuration=_configuration,
                    **kwargs,
                )
        
        @classmethod
        @functools.lru_cache()
        def all_of(cls):
            # we need this here to make our import statements work
            # we must store _composed_schemas in here so the code is only run
            # when we invoke this method. If we kept this at the class
            # level we would get an error because the class level
            # code would be run when this module is imported, and these composed
            # classes don't exist yet because their module has not finished
            # loading
            return [
                OutboundCallResult,
                cls.all_of_1,
            ]


    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'OutboundCallFailure':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
            **kwargs,
        )

from cvg_sdk.model.outbound_call_failure import OutboundCallFailure
from cvg_sdk.model.outbound_call_result import OutboundCallResult
from cvg_sdk.model.outbound_call_success import OutboundCallSuccess
