# coding: utf-8

"""
    VIER Cognitive Voice Call API

    With the VIER Cognitive Voice Call API you can easily do things like building your voicebots, which can be reached via phone calls. You can receive speech input of the customer as transcripted text in many languages. Let different voices say your text in this call. After the voicebot dialog you may drop the call (call fully completed by bot) or transfer the call e.g. to the relevant service hotline (human agent required to satisfy customer).  On some events, such as receiving an incoming phone call or transcription of a customer's utterance, VIER makes an HTTP request to a URL to be provided by you. This is called a webhook. To handle a webhook, you need to build a small web application that can accept the HTTP requests. The required webhooks are listed as bot endpoints.  The operations defined in this specification can be used by your bot to trigger certain voice and/or telephony related actions on the currently active call.  Most of the available operations are subject to queuing, meaning that the commands, even when triggered simultaneously, will not be executed simultaneously. Instead, these operations will be executed after each other. This is being done to simplify bot development as otherwise the bot would need to hit exact timings for the operations it triggers to not produce overlapping audio in the phone and still be quick enough to feel responsive to the conversation partner.  The queuing mechanism allows the bot to simply trigger several operations after each other and CVG makes sure to to execute them without overlap after each other. Some operations also support a `bargeIn` flag, which makes the operation interruptible by the conversation partner.  All operations that are not subject to queuing will document this fact in their respective description.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from cvg_sdk import schemas  # noqa: F401


class SynthesisParameters(
    schemas.ComposedSchema,
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        
        
        class all_of_1(
            schemas.DictSchema
        ):
        
        
            class MetaOapg:
                required = {
                    "text",
                }
                
                class properties:
                    
                    
                    class text(
                        schemas.StrSchema
                    ):
                    
                    
                        class MetaOapg:
                            min_length = 1
                
                    @staticmethod
                    def interpretAs() -> typing.Type['InterpretAs']:
                        return InterpretAs
                
                    @staticmethod
                    def language() -> typing.Type['Language']:
                        return Language
                
                    @staticmethod
                    def synthesizers() -> typing.Type['SynthesizerSelection']:
                        return SynthesizerSelection
                    bargeIn = schemas.BoolSchema
                    __annotations__ = {
                        "text": text,
                        "interpretAs": interpretAs,
                        "language": language,
                        "synthesizers": synthesizers,
                        "bargeIn": bargeIn,
                    }
            
            text: MetaOapg.properties.text
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["text"]) -> MetaOapg.properties.text: ...
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["interpretAs"]) -> 'InterpretAs': ...
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["language"]) -> 'Language': ...
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["synthesizers"]) -> 'SynthesizerSelection': ...
            
            @typing.overload
            def __getitem__(self, name: typing_extensions.Literal["bargeIn"]) -> MetaOapg.properties.bargeIn: ...
            
            @typing.overload
            def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
            
            def __getitem__(self, name: typing.Union[typing_extensions.Literal["text", "interpretAs", "language", "synthesizers", "bargeIn", ], str]):
                # dict_instance[name] accessor
                return super().__getitem__(name)
            
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["text"]) -> MetaOapg.properties.text: ...
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["interpretAs"]) -> typing.Union['InterpretAs', schemas.Unset]: ...
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["language"]) -> typing.Union['Language', schemas.Unset]: ...
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["synthesizers"]) -> typing.Union['SynthesizerSelection', schemas.Unset]: ...
            
            @typing.overload
            def get_item_oapg(self, name: typing_extensions.Literal["bargeIn"]) -> typing.Union[MetaOapg.properties.bargeIn, schemas.Unset]: ...
            
            @typing.overload
            def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
            
            def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["text", "interpretAs", "language", "synthesizers", "bargeIn", ], str]):
                return super().get_item_oapg(name)
            
        
            def __new__(
                cls,
                *args: typing.Union[dict, frozendict.frozendict, ],
                text: typing.Union[MetaOapg.properties.text, str, ],
                interpretAs: typing.Union['InterpretAs', schemas.Unset] = schemas.unset,
                language: typing.Union['Language', schemas.Unset] = schemas.unset,
                synthesizers: typing.Union['SynthesizerSelection', schemas.Unset] = schemas.unset,
                bargeIn: typing.Union[MetaOapg.properties.bargeIn, bool, schemas.Unset] = schemas.unset,
                _configuration: typing.Optional[schemas.Configuration] = None,
                **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
            ) -> 'all_of_1':
                return super().__new__(
                    cls,
                    *args,
                    text=text,
                    interpretAs=interpretAs,
                    language=language,
                    synthesizers=synthesizers,
                    bargeIn=bargeIn,
                    _configuration=_configuration,
                    **kwargs,
                )
        
        @classmethod
        @functools.lru_cache()
        def all_of(cls):
            # we need this here to make our import statements work
            # we must store _composed_schemas in here so the code is only run
            # when we invoke this method. If we kept this at the class
            # level we would get an error because the class level
            # code would be run when this module is imported, and these composed
            # classes don't exist yet because their module has not finished
            # loading
            return [
                CallParameters,
                cls.all_of_1,
            ]


    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SynthesisParameters':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
            **kwargs,
        )

from cvg_sdk.model.call_parameters import CallParameters
from cvg_sdk.model.interpret_as import InterpretAs
from cvg_sdk.model.language import Language
from cvg_sdk.model.synthesizer_selection import SynthesizerSelection
