# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CellularGatewayLanArgs', 'CellularGatewayLan']

@pulumi.input_type
class CellularGatewayLanArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[str],
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]]] = None):
        """
        The set of arguments for constructing a CellularGatewayLan resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]] fixed_ip_assignments: list of all fixed IP assignments for a single MG
        :param pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]] reserved_ip_ranges: list of all reserved IP ranges for a single MG
        """
        pulumi.set(__self__, "serial", serial)
        if fixed_ip_assignments is not None:
            pulumi.set(__self__, "fixed_ip_assignments", fixed_ip_assignments)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="fixedIpAssignments")
    def fixed_ip_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]]]:
        """
        list of all fixed IP assignments for a single MG
        """
        return pulumi.get(self, "fixed_ip_assignments")

    @fixed_ip_assignments.setter
    def fixed_ip_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]]]):
        pulumi.set(self, "fixed_ip_assignments", value)

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]]]:
        """
        list of all reserved IP ranges for a single MG
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]]]):
        pulumi.set(self, "reserved_ip_ranges", value)


@pulumi.input_type
class _CellularGatewayLanState:
    def __init__(__self__, *,
                 device_lan_ip: Optional[pulumi.Input[str]] = None,
                 device_name: Optional[pulumi.Input[str]] = None,
                 device_subnet: Optional[pulumi.Input[str]] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]]] = None,
                 serial: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CellularGatewayLan resources.
        :param pulumi.Input[str] device_lan_ip: Lan IP of the MG
        :param pulumi.Input[str] device_name: Name of the MG.
        :param pulumi.Input[str] device_subnet: Subnet configuration of the MG.
        :param pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]] fixed_ip_assignments: list of all fixed IP assignments for a single MG
        :param pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]] reserved_ip_ranges: list of all reserved IP ranges for a single MG
        :param pulumi.Input[str] serial: serial path parameter.
        """
        if device_lan_ip is not None:
            pulumi.set(__self__, "device_lan_ip", device_lan_ip)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if device_subnet is not None:
            pulumi.set(__self__, "device_subnet", device_subnet)
        if fixed_ip_assignments is not None:
            pulumi.set(__self__, "fixed_ip_assignments", fixed_ip_assignments)
        if reserved_ip_ranges is not None:
            pulumi.set(__self__, "reserved_ip_ranges", reserved_ip_ranges)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)

    @property
    @pulumi.getter(name="deviceLanIp")
    def device_lan_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Lan IP of the MG
        """
        return pulumi.get(self, "device_lan_ip")

    @device_lan_ip.setter
    def device_lan_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_lan_ip", value)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the MG.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="deviceSubnet")
    def device_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet configuration of the MG.
        """
        return pulumi.get(self, "device_subnet")

    @device_subnet.setter
    def device_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_subnet", value)

    @property
    @pulumi.getter(name="fixedIpAssignments")
    def fixed_ip_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]]]:
        """
        list of all fixed IP assignments for a single MG
        """
        return pulumi.get(self, "fixed_ip_assignments")

    @fixed_ip_assignments.setter
    def fixed_ip_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanFixedIpAssignmentArgs']]]]):
        pulumi.set(self, "fixed_ip_assignments", value)

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]]]:
        """
        list of all reserved IP ranges for a single MG
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @reserved_ip_ranges.setter
    def reserved_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CellularGatewayLanReservedIpRangeArgs']]]]):
        pulumi.set(self, "reserved_ip_ranges", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)


class CellularGatewayLan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanFixedIpAssignmentArgs']]]]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanReservedIpRangeArgs']]]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CellularGatewayLan("example",
            fixed_ip_assignments=[meraki.devices.CellularGatewayLanFixedIpAssignmentArgs(
                ip="192.168.0.10",
                mac="0b:00:00:00:00:ac",
                name="server 1",
            )],
            reserved_ip_ranges=[meraki.devices.CellularGatewayLanReservedIpRangeArgs(
                comment="A reserved IP range",
                end="192.168.1.1",
                start="192.168.1.0",
            )],
            serial="string")
        pulumi.export("merakiDevicesCellularGatewayLanExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cellularGatewayLan:CellularGatewayLan example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanFixedIpAssignmentArgs']]]] fixed_ip_assignments: list of all fixed IP assignments for a single MG
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanReservedIpRangeArgs']]]] reserved_ip_ranges: list of all reserved IP ranges for a single MG
        :param pulumi.Input[str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularGatewayLanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CellularGatewayLan("example",
            fixed_ip_assignments=[meraki.devices.CellularGatewayLanFixedIpAssignmentArgs(
                ip="192.168.0.10",
                mac="0b:00:00:00:00:ac",
                name="server 1",
            )],
            reserved_ip_ranges=[meraki.devices.CellularGatewayLanReservedIpRangeArgs(
                comment="A reserved IP range",
                end="192.168.1.1",
                start="192.168.1.0",
            )],
            serial="string")
        pulumi.export("merakiDevicesCellularGatewayLanExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cellularGatewayLan:CellularGatewayLan example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param CellularGatewayLanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularGatewayLanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanFixedIpAssignmentArgs']]]]] = None,
                 reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanReservedIpRangeArgs']]]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularGatewayLanArgs.__new__(CellularGatewayLanArgs)

            __props__.__dict__["fixed_ip_assignments"] = fixed_ip_assignments
            __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["device_lan_ip"] = None
            __props__.__dict__["device_name"] = None
            __props__.__dict__["device_subnet"] = None
        super(CellularGatewayLan, __self__).__init__(
            'meraki:devices/cellularGatewayLan:CellularGatewayLan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device_lan_ip: Optional[pulumi.Input[str]] = None,
            device_name: Optional[pulumi.Input[str]] = None,
            device_subnet: Optional[pulumi.Input[str]] = None,
            fixed_ip_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanFixedIpAssignmentArgs']]]]] = None,
            reserved_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanReservedIpRangeArgs']]]]] = None,
            serial: Optional[pulumi.Input[str]] = None) -> 'CellularGatewayLan':
        """
        Get an existing CellularGatewayLan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] device_lan_ip: Lan IP of the MG
        :param pulumi.Input[str] device_name: Name of the MG.
        :param pulumi.Input[str] device_subnet: Subnet configuration of the MG.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanFixedIpAssignmentArgs']]]] fixed_ip_assignments: list of all fixed IP assignments for a single MG
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CellularGatewayLanReservedIpRangeArgs']]]] reserved_ip_ranges: list of all reserved IP ranges for a single MG
        :param pulumi.Input[str] serial: serial path parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularGatewayLanState.__new__(_CellularGatewayLanState)

        __props__.__dict__["device_lan_ip"] = device_lan_ip
        __props__.__dict__["device_name"] = device_name
        __props__.__dict__["device_subnet"] = device_subnet
        __props__.__dict__["fixed_ip_assignments"] = fixed_ip_assignments
        __props__.__dict__["reserved_ip_ranges"] = reserved_ip_ranges
        __props__.__dict__["serial"] = serial
        return CellularGatewayLan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deviceLanIp")
    def device_lan_ip(self) -> pulumi.Output[str]:
        """
        Lan IP of the MG
        """
        return pulumi.get(self, "device_lan_ip")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Output[str]:
        """
        Name of the MG.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceSubnet")
    def device_subnet(self) -> pulumi.Output[str]:
        """
        Subnet configuration of the MG.
        """
        return pulumi.get(self, "device_subnet")

    @property
    @pulumi.getter(name="fixedIpAssignments")
    def fixed_ip_assignments(self) -> pulumi.Output[Sequence['outputs.CellularGatewayLanFixedIpAssignment']]:
        """
        list of all fixed IP assignments for a single MG
        """
        return pulumi.get(self, "fixed_ip_assignments")

    @property
    @pulumi.getter(name="reservedIpRanges")
    def reserved_ip_ranges(self) -> pulumi.Output[Sequence['outputs.CellularGatewayLanReservedIpRange']]:
        """
        list of all reserved IP ranges for a single MG
        """
        return pulumi.get(self, "reserved_ip_ranges")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

