# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BaseArgs', 'Base']

@pulumi.input_type
class BaseArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 enrollment_string: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Base resource.
        :param pulumi.Input[str] organization_id: Organization ID
        :param pulumi.Input[str] enrollment_string: Enrollment string for the network
        :param pulumi.Input[str] name: Network name
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] notes: Notes for the network
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_types: List of the product types that the network supports
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Network tags
        :param pulumi.Input[str] time_zone: Timezone of the network
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if enrollment_string is not None:
            pulumi.set(__self__, "enrollment_string", enrollment_string)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if product_types is not None:
            pulumi.set(__self__, "product_types", product_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="enrollmentString")
    def enrollment_string(self) -> Optional[pulumi.Input[str]]:
        """
        Enrollment string for the network
        """
        return pulumi.get(self, "enrollment_string")

    @enrollment_string.setter
    def enrollment_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enrollment_string", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Network name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Notes for the network
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the product types that the network supports
        """
        return pulumi.get(self, "product_types")

    @product_types.setter
    def product_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "product_types", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Timezone of the network
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _BaseState:
    def __init__(__self__, *,
                 enrollment_string: Optional[pulumi.Input[str]] = None,
                 is_bound_to_config_template: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Base resources.
        :param pulumi.Input[str] enrollment_string: Enrollment string for the network
        :param pulumi.Input[bool] is_bound_to_config_template: If the network is bound to a config template
        :param pulumi.Input[str] name: Network name
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] notes: Notes for the network
        :param pulumi.Input[str] organization_id: Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_types: List of the product types that the network supports
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Network tags
        :param pulumi.Input[str] time_zone: Timezone of the network
        :param pulumi.Input[str] url: URL to the network Dashboard UI
        """
        if enrollment_string is not None:
            pulumi.set(__self__, "enrollment_string", enrollment_string)
        if is_bound_to_config_template is not None:
            pulumi.set(__self__, "is_bound_to_config_template", is_bound_to_config_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if product_types is not None:
            pulumi.set(__self__, "product_types", product_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="enrollmentString")
    def enrollment_string(self) -> Optional[pulumi.Input[str]]:
        """
        Enrollment string for the network
        """
        return pulumi.get(self, "enrollment_string")

    @enrollment_string.setter
    def enrollment_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enrollment_string", value)

    @property
    @pulumi.getter(name="isBoundToConfigTemplate")
    def is_bound_to_config_template(self) -> Optional[pulumi.Input[bool]]:
        """
        If the network is bound to a config template
        """
        return pulumi.get(self, "is_bound_to_config_template")

    @is_bound_to_config_template.setter
    def is_bound_to_config_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_bound_to_config_template", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Network name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Notes for the network
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the product types that the network supports
        """
        return pulumi.get(self, "product_types")

    @product_types.setter
    def product_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "product_types", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Timezone of the network
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL to the network Dashboard UI
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class Base(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enrollment_string: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Base("example",
            name="Main Office",
            notes="Additional description of the network",
            organization_id="string",
            product_types=[
                "appliance",
                "switch",
                "wireless",
            ],
            tags=[
                "tag1",
                "tag2",
            ],
            time_zone="America/Los_Angeles")
        pulumi.export("merakiNetworksExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/base:base example "network_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] enrollment_string: Enrollment string for the network
        :param pulumi.Input[str] name: Network name
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] notes: Notes for the network
        :param pulumi.Input[str] organization_id: Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_types: List of the product types that the network supports
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Network tags
        :param pulumi.Input[str] time_zone: Timezone of the network
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Base("example",
            name="Main Office",
            notes="Additional description of the network",
            organization_id="string",
            product_types=[
                "appliance",
                "switch",
                "wireless",
            ],
            tags=[
                "tag1",
                "tag2",
            ],
            time_zone="America/Los_Angeles")
        pulumi.export("merakiNetworksExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/base:base example "network_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param BaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enrollment_string: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaseArgs.__new__(BaseArgs)

            __props__.__dict__["enrollment_string"] = enrollment_string
            __props__.__dict__["name"] = name
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["notes"] = notes
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["product_types"] = product_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["is_bound_to_config_template"] = None
            __props__.__dict__["url"] = None
        super(Base, __self__).__init__(
            'meraki:networks/base:base',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enrollment_string: Optional[pulumi.Input[str]] = None,
            is_bound_to_config_template: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            notes: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            product_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'Base':
        """
        Get an existing Base resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] enrollment_string: Enrollment string for the network
        :param pulumi.Input[bool] is_bound_to_config_template: If the network is bound to a config template
        :param pulumi.Input[str] name: Network name
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] notes: Notes for the network
        :param pulumi.Input[str] organization_id: Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] product_types: List of the product types that the network supports
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Network tags
        :param pulumi.Input[str] time_zone: Timezone of the network
        :param pulumi.Input[str] url: URL to the network Dashboard UI
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaseState.__new__(_BaseState)

        __props__.__dict__["enrollment_string"] = enrollment_string
        __props__.__dict__["is_bound_to_config_template"] = is_bound_to_config_template
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["notes"] = notes
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["product_types"] = product_types
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["url"] = url
        return Base(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enrollmentString")
    def enrollment_string(self) -> pulumi.Output[str]:
        """
        Enrollment string for the network
        """
        return pulumi.get(self, "enrollment_string")

    @property
    @pulumi.getter(name="isBoundToConfigTemplate")
    def is_bound_to_config_template(self) -> pulumi.Output[bool]:
        """
        If the network is bound to a config template
        """
        return pulumi.get(self, "is_bound_to_config_template")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Network name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[str]:
        """
        Notes for the network
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of the product types that the network supports
        """
        return pulumi.get(self, "product_types")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Network tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        Timezone of the network
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        URL to the network Dashboard UI
        """
        return pulumi.get(self, "url")

