# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionBatchesArgs', 'ActionBatches']

@pulumi.input_type
class ActionBatchesArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 action_batch_id: Optional[pulumi.Input[str]] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]]] = None,
                 callback: Optional[pulumi.Input['ActionBatchesCallbackArgs']] = None,
                 confirmed: Optional[pulumi.Input[bool]] = None,
                 synchronous: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ActionBatches resource.
        :param pulumi.Input[str] organization_id: ID of the organization this action batch belongs to
        :param pulumi.Input[str] action_batch_id: actionBatchId path parameter. Action batch ID
        :param pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]] actions: A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        :param pulumi.Input['ActionBatchesCallbackArgs'] callback: Information for callback used to send back results
        :param pulumi.Input[bool] confirmed: Flag describing whether the action should be previewed before executing or not
        :param pulumi.Input[bool] synchronous: Flag describing whether actions should run synchronously or asynchronously
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if action_batch_id is not None:
            pulumi.set(__self__, "action_batch_id", action_batch_id)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if confirmed is not None:
            pulumi.set(__self__, "confirmed", confirmed)
        if synchronous is not None:
            pulumi.set(__self__, "synchronous", synchronous)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        ID of the organization this action batch belongs to
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="actionBatchId")
    def action_batch_id(self) -> Optional[pulumi.Input[str]]:
        """
        actionBatchId path parameter. Action batch ID
        """
        return pulumi.get(self, "action_batch_id")

    @action_batch_id.setter
    def action_batch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_batch_id", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]]]:
        """
        A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['ActionBatchesCallbackArgs']]:
        """
        Information for callback used to send back results
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['ActionBatchesCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter
    def confirmed(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag describing whether the action should be previewed before executing or not
        """
        return pulumi.get(self, "confirmed")

    @confirmed.setter
    def confirmed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confirmed", value)

    @property
    @pulumi.getter
    def synchronous(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag describing whether actions should run synchronously or asynchronously
        """
        return pulumi.get(self, "synchronous")

    @synchronous.setter
    def synchronous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "synchronous", value)


@pulumi.input_type
class _ActionBatchesState:
    def __init__(__self__, *,
                 action_batch_id: Optional[pulumi.Input[str]] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]]] = None,
                 callback: Optional[pulumi.Input['ActionBatchesCallbackArgs']] = None,
                 confirmed: Optional[pulumi.Input[bool]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['ActionBatchesStatusArgs']] = None,
                 synchronous: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ActionBatches resources.
        :param pulumi.Input[str] action_batch_id: actionBatchId path parameter. Action batch ID
        :param pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]] actions: A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        :param pulumi.Input['ActionBatchesCallbackArgs'] callback: Information for callback used to send back results
        :param pulumi.Input[bool] confirmed: Flag describing whether the action should be previewed before executing or not
        :param pulumi.Input[str] organization_id: ID of the organization this action batch belongs to
        :param pulumi.Input['ActionBatchesStatusArgs'] status: Status of action batch
        :param pulumi.Input[bool] synchronous: Flag describing whether actions should run synchronously or asynchronously
        """
        if action_batch_id is not None:
            pulumi.set(__self__, "action_batch_id", action_batch_id)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if confirmed is not None:
            pulumi.set(__self__, "confirmed", confirmed)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if synchronous is not None:
            pulumi.set(__self__, "synchronous", synchronous)

    @property
    @pulumi.getter(name="actionBatchId")
    def action_batch_id(self) -> Optional[pulumi.Input[str]]:
        """
        actionBatchId path parameter. Action batch ID
        """
        return pulumi.get(self, "action_batch_id")

    @action_batch_id.setter
    def action_batch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_batch_id", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]]]:
        """
        A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionBatchesActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['ActionBatchesCallbackArgs']]:
        """
        Information for callback used to send back results
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['ActionBatchesCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter
    def confirmed(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag describing whether the action should be previewed before executing or not
        """
        return pulumi.get(self, "confirmed")

    @confirmed.setter
    def confirmed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confirmed", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the organization this action batch belongs to
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ActionBatchesStatusArgs']]:
        """
        Status of action batch
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ActionBatchesStatusArgs']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def synchronous(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag describing whether actions should run synchronously or asynchronously
        """
        return pulumi.get(self, "synchronous")

    @synchronous.setter
    def synchronous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "synchronous", value)


class ActionBatches(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_batch_id: Optional[pulumi.Input[str]] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionBatchesActionArgs']]]]] = None,
                 callback: Optional[pulumi.Input[pulumi.InputType['ActionBatchesCallbackArgs']]] = None,
                 confirmed: Optional[pulumi.Input[bool]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 synchronous: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/actionBatches:ActionBatches example "action_batch_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action_batch_id: actionBatchId path parameter. Action batch ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionBatchesActionArgs']]]] actions: A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        :param pulumi.Input[pulumi.InputType['ActionBatchesCallbackArgs']] callback: Information for callback used to send back results
        :param pulumi.Input[bool] confirmed: Flag describing whether the action should be previewed before executing or not
        :param pulumi.Input[str] organization_id: ID of the organization this action batch belongs to
        :param pulumi.Input[bool] synchronous: Flag describing whether actions should run synchronously or asynchronously
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionBatchesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/actionBatches:ActionBatches example "action_batch_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param ActionBatchesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionBatchesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_batch_id: Optional[pulumi.Input[str]] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionBatchesActionArgs']]]]] = None,
                 callback: Optional[pulumi.Input[pulumi.InputType['ActionBatchesCallbackArgs']]] = None,
                 confirmed: Optional[pulumi.Input[bool]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 synchronous: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionBatchesArgs.__new__(ActionBatchesArgs)

            __props__.__dict__["action_batch_id"] = action_batch_id
            __props__.__dict__["actions"] = actions
            __props__.__dict__["callback"] = callback
            __props__.__dict__["confirmed"] = confirmed
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["synchronous"] = synchronous
            __props__.__dict__["status"] = None
        super(ActionBatches, __self__).__init__(
            'meraki:organizations/actionBatches:ActionBatches',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_batch_id: Optional[pulumi.Input[str]] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionBatchesActionArgs']]]]] = None,
            callback: Optional[pulumi.Input[pulumi.InputType['ActionBatchesCallbackArgs']]] = None,
            confirmed: Optional[pulumi.Input[bool]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[pulumi.InputType['ActionBatchesStatusArgs']]] = None,
            synchronous: Optional[pulumi.Input[bool]] = None) -> 'ActionBatches':
        """
        Get an existing ActionBatches resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action_batch_id: actionBatchId path parameter. Action batch ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ActionBatchesActionArgs']]]] actions: A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        :param pulumi.Input[pulumi.InputType['ActionBatchesCallbackArgs']] callback: Information for callback used to send back results
        :param pulumi.Input[bool] confirmed: Flag describing whether the action should be previewed before executing or not
        :param pulumi.Input[str] organization_id: ID of the organization this action batch belongs to
        :param pulumi.Input[pulumi.InputType['ActionBatchesStatusArgs']] status: Status of action batch
        :param pulumi.Input[bool] synchronous: Flag describing whether actions should run synchronously or asynchronously
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionBatchesState.__new__(_ActionBatchesState)

        __props__.__dict__["action_batch_id"] = action_batch_id
        __props__.__dict__["actions"] = actions
        __props__.__dict__["callback"] = callback
        __props__.__dict__["confirmed"] = confirmed
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["status"] = status
        __props__.__dict__["synchronous"] = synchronous
        return ActionBatches(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionBatchId")
    def action_batch_id(self) -> pulumi.Output[str]:
        """
        actionBatchId path parameter. Action batch ID
        """
        return pulumi.get(self, "action_batch_id")

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.ActionBatchesAction']]:
        """
        A set of changes made as part of this action (\\n\\nmore details\\n\\n)
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def callback(self) -> pulumi.Output['outputs.ActionBatchesCallback']:
        """
        Information for callback used to send back results
        """
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter
    def confirmed(self) -> pulumi.Output[bool]:
        """
        Flag describing whether the action should be previewed before executing or not
        """
        return pulumi.get(self, "confirmed")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        ID of the organization this action batch belongs to
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.ActionBatchesStatus']:
        """
        Status of action batch
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def synchronous(self) -> pulumi.Output[bool]:
        """
        Flag describing whether actions should run synchronously or asynchronously
        """
        return pulumi.get(self, "synchronous")

