# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDevicesUplinksLossAndLatencyResult',
    'AwaitableGetDevicesUplinksLossAndLatencyResult',
    'get_devices_uplinks_loss_and_latency',
    'get_devices_uplinks_loss_and_latency_output',
]

@pulumi.output_type
class GetDevicesUplinksLossAndLatencyResult:
    """
    A collection of values returned by getDevicesUplinksLossAndLatency.
    """
    def __init__(__self__, id=None, ip=None, items=None, organization_id=None, t0=None, t1=None, timespan=None, uplink=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if t0 and not isinstance(t0, str):
            raise TypeError("Expected argument 't0' to be a str")
        pulumi.set(__self__, "t0", t0)
        if t1 and not isinstance(t1, str):
            raise TypeError("Expected argument 't1' to be a str")
        pulumi.set(__self__, "t1", t1)
        if timespan and not isinstance(timespan, float):
            raise TypeError("Expected argument 'timespan' to be a float")
        pulumi.set(__self__, "timespan", timespan)
        if uplink and not isinstance(uplink, str):
            raise TypeError("Expected argument 'uplink' to be a str")
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        ip query parameter. Optional filter for a specific destination IP. Default will return all destination IPs.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDevicesUplinksLossAndLatencyItemResult']:
        """
        Array of ResponseOrganizationsGetOrganizationDevicesUplinksLossAndLatency
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def t0(self) -> Optional[str]:
        """
        t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 60 days from today.
        """
        return pulumi.get(self, "t0")

    @property
    @pulumi.getter
    def t1(self) -> Optional[str]:
        """
        t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 5 minutes after t0. The latest possible time that t1 can be is 2 minutes into the past.
        """
        return pulumi.get(self, "t1")

    @property
    @pulumi.getter
    def timespan(self) -> Optional[float]:
        """
        timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 5 minutes. The default is 5 minutes.
        """
        return pulumi.get(self, "timespan")

    @property
    @pulumi.getter
    def uplink(self) -> Optional[str]:
        """
        uplink query parameter. Optional filter for a specific WAN uplink. Valid uplinks are wan1, wan2, wan3, cellular. Default will return all uplinks.
        """
        return pulumi.get(self, "uplink")


class AwaitableGetDevicesUplinksLossAndLatencyResult(GetDevicesUplinksLossAndLatencyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDevicesUplinksLossAndLatencyResult(
            id=self.id,
            ip=self.ip,
            items=self.items,
            organization_id=self.organization_id,
            t0=self.t0,
            t1=self.t1,
            timespan=self.timespan,
            uplink=self.uplink)


def get_devices_uplinks_loss_and_latency(ip: Optional[str] = None,
                                         organization_id: Optional[str] = None,
                                         t0: Optional[str] = None,
                                         t1: Optional[str] = None,
                                         timespan: Optional[float] = None,
                                         uplink: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDevicesUplinksLossAndLatencyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_devices_uplinks_loss_and_latency(ip="string",
        organization_id="string",
        t0="string",
        t1="string",
        timespan=1,
        uplink="string")
    pulumi.export("merakiOrganizationsDevicesUplinksLossAndLatencyExample", example.items)
    ```


    :param str ip: ip query parameter. Optional filter for a specific destination IP. Default will return all destination IPs.
    :param str organization_id: organizationId path parameter. Organization ID
    :param str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 60 days from today.
    :param str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 5 minutes after t0. The latest possible time that t1 can be is 2 minutes into the past.
    :param float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 5 minutes. The default is 5 minutes.
    :param str uplink: uplink query parameter. Optional filter for a specific WAN uplink. Valid uplinks are wan1, wan2, wan3, cellular. Default will return all uplinks.
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['organizationId'] = organization_id
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    __args__['uplink'] = uplink
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getDevicesUplinksLossAndLatency:getDevicesUplinksLossAndLatency', __args__, opts=opts, typ=GetDevicesUplinksLossAndLatencyResult).value

    return AwaitableGetDevicesUplinksLossAndLatencyResult(
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        items=pulumi.get(__ret__, 'items'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        t0=pulumi.get(__ret__, 't0'),
        t1=pulumi.get(__ret__, 't1'),
        timespan=pulumi.get(__ret__, 'timespan'),
        uplink=pulumi.get(__ret__, 'uplink'))


@_utilities.lift_output_func(get_devices_uplinks_loss_and_latency)
def get_devices_uplinks_loss_and_latency_output(ip: Optional[pulumi.Input[Optional[str]]] = None,
                                                organization_id: Optional[pulumi.Input[str]] = None,
                                                t0: Optional[pulumi.Input[Optional[str]]] = None,
                                                t1: Optional[pulumi.Input[Optional[str]]] = None,
                                                timespan: Optional[pulumi.Input[Optional[float]]] = None,
                                                uplink: Optional[pulumi.Input[Optional[str]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDevicesUplinksLossAndLatencyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_devices_uplinks_loss_and_latency(ip="string",
        organization_id="string",
        t0="string",
        t1="string",
        timespan=1,
        uplink="string")
    pulumi.export("merakiOrganizationsDevicesUplinksLossAndLatencyExample", example.items)
    ```


    :param str ip: ip query parameter. Optional filter for a specific destination IP. Default will return all destination IPs.
    :param str organization_id: organizationId path parameter. Organization ID
    :param str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 60 days from today.
    :param str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 5 minutes after t0. The latest possible time that t1 can be is 2 minutes into the past.
    :param float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 5 minutes. The default is 5 minutes.
    :param str uplink: uplink query parameter. Optional filter for a specific WAN uplink. Valid uplinks are wan1, wan2, wan3, cellular. Default will return all uplinks.
    """
    ...
