import numpy as np
from torch.utils.data import DataLoader, TensorDataset
from torch import Tensor
from sklearn.model_selection import train_test_split
import torch
from os import listdir
import os
import logging
from PIL import Image
from os.path import isfile, join


def malnettiny(
        path_to_dataset: str = '',
        batch_size: int = 128,
        image_resolution: int = 32,
        datasets=None
):
    # Validate that the parameters are within bounds
    if datasets is None:
        datasets = ['train', 'val']
    if path_to_dataset == '':
        raise Exception("path_to_dataset must be specified")
    if len(datasets) > 3 or len(datasets) < 1:
        raise Exception("datasets must be a list of length 1-3")
    if not np.in1d(datasets, ['train', 'val', 'test']).all():
        raise Exception("datasets must be a list of 'train', 'val', and/or 'test'")
    # specify the known expected sample count for the dataset
    expected_sample_count = {'train': 61201, 'val': 8743, 'test': 17486}
    # specify the known labels of the dataset
    labels = ['dropper++trojan', 'spy', 'rog', 'smssend++trojan', 'gray', 'troj', 'addisplay', 'hacktool', 'monitor',
              'exploit', 'fakeangry', 'clicker', 'addisplay++adware', 'banker++trojan', 'spy++trojan',
              'fakeapp++trojan', 'malware++trj', 'backdoor', 'adware++grayware++virus', 'riskware++smssend', 'click',
              'downloader', 'malware', 'adwareare', 'fakeapp', 'trojandropper', 'clickfraud++riskware',
              'clicker++trojan', 'adware++virus', 'spyware', 'spr', 'smssend', 'adware++adware', 'trj', 'worm',
              'fakeinst++trojan', 'trojandownloader', 'risktool++riskware++virus', 'adload', 'adsware',
              'rootnik++trojan', 'virus', 'ransom++trojan']
    # define the loaders dictionary with the metadata of what will be loaded
    loaders = {
        'image_resolution': image_resolution,
        'batch_size': batch_size,
        'expected_sample_count': expected_sample_count,
        'labels': labels,
        'input_channels': 1
    }
    path_to_dataset = path_to_dataset+'/Mal-Net/malnet-images-tiny'
    logging.info('--- BEGIN LOADING DATASET ---')
    for set in datasets:
        # for each of the datasets that have to be loaded,
        # get the file paths, open the images, convert to grayscale,
        # and resize to defined image resolution
        features = []
        full_labels = []
        for index, label in enumerate(labels):
            logging.info(f'LOADING {set.upper()} SET: CLASS {index+1} OF {len(labels)}')
            path = path_to_dataset + f'/{set}/{label}'
            files = [f for f in listdir(path) if isfile(join(path, f))]
            files_full = []
            for path, subdirs, files in os.walk(path):
                files = [f for f in listdir(path) if isfile(join(path, f))]
                for name in files:
                    if isfile(os.path.join(path, name)) and not name.startswith('.'):
                        files_full.append(os.path.join(path, name))
            images = [Image.open(f).convert('L') for f in files_full]
            images = [img.resize((image_resolution, image_resolution)) for img in images]
            images_np = [np.asarray(img) for img in images]
            features.extend(images_np)
            full_labels.extend([index for i in range(len(images_np))])
        # Resize the data and check that the samples are in the correct size
        logging.info(f'--- {set.upper()} DATASET LOADING COMPLETE ---')
        logging.info(f'--- BEGIN {set.upper()} DATASET PREPROCESSING ---')
        features = np.asarray([feature for feature in features])
        full_labels = np.array([label for label in full_labels])
        # Shuffles the dataset
        idx = np.random.choice(len(full_labels), len(full_labels))
        full_labels = full_labels[idx]
        features = features[idx]
        if len(full_labels) != expected_sample_count[set]:
            raise Exception(f"Expected {expected_sample_count[set]} samples in dataset, but got {len(full_labels)}")
        full_labels = full_labels.reshape((len(full_labels), 1))
        X_train = features.reshape((len(features), 1, image_resolution, image_resolution))
        new_y_train = np.zeros((len(X_train), len(labels)))
        # Set the labels value to the index of the classes
        for ind, val in enumerate(full_labels):
            tmp = np.zeros(len(labels))
            tmp[val] = 1
            new_y_train[ind] = tmp
        y_train = new_y_train
        # convert the numpy arrays to tensors and create the dataset and loader
        dataset = TensorDataset(Tensor(X_train), torch.argmax(Tensor(y_train), dim=1))
        loaders[set] = DataLoader(dataset, batch_size=batch_size)
        logging.info(f'--- {set.upper()} DATASET PREPROCESSING COMPLETE ---')
    return loaders
