"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.MetricsLevel = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Available log levels for Flink applications.
 */
var LogLevel;
(function (LogLevel) {
    /** Debug level logging */
    LogLevel["DEBUG"] = "DEBUG";
    /** Info level logging */
    LogLevel["INFO"] = "INFO";
    /** Warn level logging */
    LogLevel["WARN"] = "WARN";
    /** Error level logging */
    LogLevel["ERROR"] = "ERROR";
})(LogLevel || (exports.LogLevel = LogLevel = {}));
/**
 * Granularity of metrics sent to CloudWatch.
 */
var MetricsLevel;
(function (MetricsLevel) {
    /** Application sends the least metrics to CloudWatch */
    MetricsLevel["APPLICATION"] = "APPLICATION";
    /** Task includes task-level metrics sent to CloudWatch */
    MetricsLevel["TASK"] = "TASK";
    /** Operator includes task-level and operator-level metrics sent to CloudWatch */
    MetricsLevel["OPERATOR"] = "OPERATOR";
    /** Send all metrics including metrics per task thread */
    MetricsLevel["PARALLELISM"] = "PARALLELISM";
})(MetricsLevel || (exports.MetricsLevel = MetricsLevel = {}));
/**
 * Available Flink runtimes for Kinesis Analytics.
 */
class Runtime {
    /** Create a new Runtime with with an arbitrary Flink version string */
    static of(value) {
        return new Runtime(value);
    }
    constructor(value) {
        this.value = value;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink-alpha.Runtime", version: "2.134.0-alpha.0" };
/** Flink Version 1.6 */
Runtime.FLINK_1_6 = Runtime.of('FLINK-1_6');
/** Flink Version 1.8 */
Runtime.FLINK_1_8 = Runtime.of('FLINK-1_8');
/** Flink Version 1.11 */
Runtime.FLINK_1_11 = Runtime.of('FLINK-1_11');
/** Flink Version 1.13 */
Runtime.FLINK_1_13 = Runtime.of('FLINK-1_13');
/** Flink Version 1.15 */
Runtime.FLINK_1_15 = Runtime.of('FLINK-1_15');
/** Flink Version 1.18 */
Runtime.FLINK_1_18 = Runtime.of('FLINK-1_18');
//# sourceMappingURL=data:application/json;base64,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