/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.groundrulestore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.util.IteratorUtils;

public class MemoryGroundRuleStore
implements GroundRuleStore {
    protected List<GroundRule> groundRules = new ArrayList<GroundRule>();

    @Override
    public synchronized void addGroundRule(GroundRule groundRule) {
        this.groundRules.add(groundRule);
    }

    @Override
    public boolean containsGroundRule(GroundRule groundRule) {
        return this.groundRules.contains(groundRule);
    }

    @Override
    public Iterable<WeightedGroundRule> getCompatibilityRules() {
        return IteratorUtils.filterClass(this.groundRules, WeightedGroundRule.class);
    }

    @Override
    public Iterable<UnweightedGroundRule> getConstraintRules() {
        return IteratorUtils.filterClass(this.groundRules, UnweightedGroundRule.class);
    }

    @Override
    public Iterable<GroundRule> getGroundRules() {
        return this.groundRules;
    }

    @Override
    public Iterable<GroundRule> getGroundRules(Rule rule) {
        final Rule finalRule = rule;
        return IteratorUtils.filter(this.groundRules, new IteratorUtils.FilterFunction<GroundRule>(){

            @Override
            public boolean keep(GroundRule groundRule) {
                return finalRule.equals(groundRule.getRule());
            }
        });
    }

    @Override
    public void removeGroundRule(GroundRule groundRule) {
        this.groundRules.remove(groundRule);
    }

    @Override
    public void removeGroundRules(Rule rule) {
        Iterator<GroundRule> iterator = this.groundRules.iterator();
        while (iterator.hasNext()) {
            GroundRule groundRule = iterator.next();
            if (!rule.equals(groundRule.getRule())) continue;
            iterator.remove();
        }
    }

    @Override
    public int size() {
        return this.groundRules.size();
    }

    @Override
    public int count(Rule rule) {
        int count = 0;
        for (GroundRule groundRule : this.groundRules) {
            if (!rule.equals(groundRule.getRule())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        if (this.groundRules != null) {
            this.groundRules.clear();
            this.groundRules = null;
        }
    }
}

