/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.util;

import java.util.ArrayList;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;

public class GroundRules {
    public static double getTotalWeightedIncompatibility(Iterable<WeightedGroundRule> groundRules) {
        double totalInc = 0.0;
        for (WeightedGroundRule groundRule : groundRules) {
            totalInc += groundRule.getIncompatibility() * groundRule.getWeight();
        }
        return totalInc;
    }

    public static double getTotalWeightedCompatibility(Iterable<WeightedGroundRule> groundRules) {
        double totalInc = 0.0;
        for (WeightedGroundRule groundRule : groundRules) {
            totalInc += (1.0 - groundRule.getIncompatibility()) * groundRule.getWeight();
        }
        return totalInc;
    }

    public static double getExpectedTotalWeightedIncompatibility(Iterable<WeightedGroundRule> groundRules) {
        double totalInc = 0.0;
        ArrayList<RandomVariableAtom> atoms = new ArrayList<RandomVariableAtom>();
        for (WeightedGroundRule groundRule : groundRules) {
            int i;
            double inc = 0.0;
            for (GroundAtom atom : groundRule.getAtoms()) {
                if (!(atom instanceof RandomVariableAtom)) continue;
                atoms.add((RandomVariableAtom)atom);
            }
            float[] truthValues = new float[atoms.size()];
            for (i = 0; i < truthValues.length; ++i) {
                truthValues[i] = ((RandomVariableAtom)atoms.get(i)).getValue();
            }
            i = 0;
            while ((double)i < Math.pow(2.0, atoms.size())) {
                float assignmentProb = 1.0f;
                for (int j = 0; j < atoms.size(); ++j) {
                    int assignment = i >> j & 1;
                    ((RandomVariableAtom)atoms.get(j)).setValue(assignment);
                    assignmentProb *= assignment == 1 ? truthValues[j] : 1.0f - truthValues[j];
                }
                inc += (double)assignmentProb * groundRule.getIncompatibility();
                ++i;
            }
            for (i = 0; i < atoms.size(); ++i) {
                ((RandomVariableAtom)atoms.get(i)).setValue(truthValues[i]);
            }
            atoms.clear();
            totalInc += (inc *= groundRule.getWeight());
        }
        return totalInc;
    }

    public static double getExpectedTotalWeightedCompatibility(Iterable<WeightedGroundRule> groundRules) {
        double totalInc = 0.0;
        for (WeightedGroundRule groundRule : groundRules) {
            totalInc += GroundRules.getExpectedWeightedCompatibility(groundRule);
        }
        return totalInc;
    }

    public static double getExpectedWeightedCompatibility(WeightedGroundRule groundRule) {
        int i;
        double inc = 0.0;
        ArrayList<RandomVariableAtom> atoms = new ArrayList<RandomVariableAtom>();
        for (GroundAtom atom : groundRule.getAtoms()) {
            if (!(atom instanceof RandomVariableAtom)) continue;
            atoms.add((RandomVariableAtom)atom);
        }
        float[] truthValues = new float[atoms.size()];
        for (i = 0; i < truthValues.length; ++i) {
            truthValues[i] = ((RandomVariableAtom)atoms.get(i)).getValue();
        }
        i = 0;
        while ((double)i < Math.pow(2.0, atoms.size())) {
            float assignmentProb = 1.0f;
            for (int j = 0; j < atoms.size(); ++j) {
                int assignment = i >> j & 1;
                ((RandomVariableAtom)atoms.get(j)).setValue(assignment);
                assignmentProb *= assignment == 1 ? truthValues[j] : 1.0f - truthValues[j];
            }
            inc += (double)assignmentProb * (1.0 - groundRule.getIncompatibility());
            ++i;
        }
        for (i = 0; i < atoms.size(); ++i) {
            ((RandomVariableAtom)atoms.get(i)).setValue(truthValues[i]);
        }
        return inc * groundRule.getWeight();
    }

    public static double getInfeasibilityNorm(Iterable<UnweightedGroundRule> groundRules) {
        double norm = 0.0;
        for (UnweightedGroundRule groundRule : groundRules) {
            double inf = groundRule.getInfeasibility();
            norm += inf * inf;
        }
        return Math.sqrt(norm);
    }
}

