/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.log4j.PropertyConfigurator;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.application.inference.InferenceApplication;
import org.linqs.psl.application.inference.MPEInference;
import org.linqs.psl.application.learning.weight.WeightLearningApplication;
import org.linqs.psl.application.learning.weight.maxlikelihood.MaxLikelihoodMPE;
import org.linqs.psl.cli.DataLoader;
import org.linqs.psl.config.Config;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.database.rdbms.driver.H2DatabaseDriver;
import org.linqs.psl.database.rdbms.driver.PostgreSQLDriver;
import org.linqs.psl.evaluation.statistics.Evaluator;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.parser.ModelLoader;
import org.linqs.psl.util.Reflection;
import org.linqs.psl.util.StringUtils;
import org.linqs.psl.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    public static final String OPTION_HELP = "h";
    public static final String OPTION_HELP_LONG = "help";
    public static final String OPERATION_INFER = "i";
    public static final String OPERATION_INFER_LONG = "infer";
    public static final String OPERATION_LEARN = "l";
    public static final String OPERATION_LEARN_LONG = "learn";
    public static final String OPTION_DATA = "d";
    public static final String OPTION_DATA_LONG = "data";
    public static final String OPTION_DB_H2_PATH = "h2path";
    public static final String OPTION_DB_POSTGRESQL_NAME = "postgres";
    public static final String OPTION_EVAL = "e";
    public static final String OPTION_EVAL_LONG = "eval";
    public static final String OPTION_INT_IDS = "int";
    public static final String OPTION_INT_IDS_LONG = "int-ids";
    public static final String OPTION_LOG4J = "4j";
    public static final String OPTION_LOG4J_LONG = "log4j";
    public static final String OPTION_MODEL = "m";
    public static final String OPTION_MODEL_LONG = "model";
    public static final String OPTION_OUTPUT_DIR = "o";
    public static final String OPTION_OUTPUT_DIR_LONG = "output";
    public static final String OPTION_OUTPUT_GROUND_RULES_LONG = "groundrules";
    public static final String OPTION_OUTPUT_SATISFACTION_LONG = "satisfaction";
    public static final String OPTION_PROPERTIES = "D";
    public static final String OPTION_PROPERTIES_FILE = "p";
    public static final String OPTION_PROPERTIES_FILE_LONG = "properties";
    public static final String OPTION_VERSION = "v";
    public static final String OPTION_VERSION_LONG = "version";
    public static final String MODEL_FILE_EXTENSION = ".psl";
    public static final String DEFAULT_H2_DB_PATH = Paths.get(System.getProperty("java.io.tmpdir"), "cli_" + System.getProperty("user.name") + "@" + Launcher.getHostname()).toString();
    public static final String DEFAULT_POSTGRES_DB_NAME = "psl_cli";
    public static final String DEFAULT_IA = MPEInference.class.getName();
    public static final String DEFAULT_WLA = MaxLikelihoodMPE.class.getName();
    public static final String PARTITION_NAME_OBSERVATIONS = "observations";
    public static final String PARTITION_NAME_TARGET = "targets";
    public static final String PARTITION_NAME_LABELS = "truth";
    private CommandLine options;
    private Logger log;

    private Launcher(CommandLine options) {
        this.options = options;
        this.log = this.initLogger();
        this.initConfig();
    }

    private Logger initLogger() {
        Properties props = new Properties();
        if (this.options.hasOption(OPTION_LOG4J)) {
            try {
                props.load(new FileReader(this.options.getOptionValue(OPTION_LOG4J)));
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read logger configuration from a file.", ex);
            }
        } else {
            props.setProperty("log4j.rootLogger", "INFO, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        }
        for (Map.Entry<Object, Object> entry : this.options.getOptionProperties(OPTION_PROPERTIES).entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("log4j.")) continue;
            props.setProperty(key, entry.getValue().toString());
        }
        if (props.containsKey("log4j.threshold")) {
            props.setProperty("log4j.rootLogger", props.getProperty("log4j.threshold") + ", A1");
        }
        java.util.logging.Logger rootJavaLogger = LogManager.getLogManager().getLogger("");
        rootJavaLogger.setLevel(Level.SEVERE);
        for (Handler handler : rootJavaLogger.getHandlers()) {
            handler.setLevel(Level.SEVERE);
        }
        PropertyConfigurator.configure(props);
        return LoggerFactory.getLogger(Launcher.class);
    }

    private static void initDefaultLogger() {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "INFO, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        PropertyConfigurator.configure(props);
    }

    private void initConfig() {
        if (this.options.hasOption(OPTION_PROPERTIES_FILE)) {
            String propertiesPath = this.options.getOptionValue(OPTION_PROPERTIES_FILE);
            Config.loadResource(propertiesPath);
        }
        for (Map.Entry<Object, Object> entry : this.options.getOptionProperties(OPTION_PROPERTIES).entrySet()) {
            String key = entry.getKey().toString();
            Config.setProperty(key, entry.getValue());
        }
    }

    private DataStore initDataStore() {
        String dbPath = DEFAULT_H2_DB_PATH;
        boolean useH2 = true;
        if (this.options.hasOption(OPTION_DB_H2_PATH)) {
            dbPath = this.options.getOptionValue(OPTION_DB_H2_PATH);
        } else if (this.options.hasOption(OPTION_DB_POSTGRESQL_NAME)) {
            dbPath = this.options.getOptionValue(OPTION_DB_POSTGRESQL_NAME, DEFAULT_POSTGRES_DB_NAME);
            useH2 = false;
        }
        DatabaseDriver driver = null;
        driver = useH2 ? new H2DatabaseDriver(H2DatabaseDriver.Type.Disk, dbPath, true) : new PostgreSQLDriver(dbPath, true);
        return new RDBMSDataStore(driver);
    }

    private Set<StandardPredicate> loadData(DataStore dataStore) {
        Set<StandardPredicate> closedPredicates;
        this.log.info("Loading data");
        try {
            String path = this.options.getOptionValue(OPTION_DATA);
            closedPredicates = DataLoader.load(dataStore, path, this.options.hasOption(OPTION_INT_IDS));
        }
        catch (FileNotFoundException | ConfigurationException ex) {
            throw new RuntimeException("Failed to load data.", ex);
        }
        this.log.info("Data loading complete");
        return closedPredicates;
    }

    private void outputGroundRules(GroundRuleStore groundRuleStore, String path, boolean includeSatisfaction) {
        PrintStream stream = System.out;
        boolean closeStream = false;
        if (path != null) {
            try {
                stream = new PrintStream(path);
                closeStream = true;
            }
            catch (IOException ex) {
                this.log.error(String.format("Unable to open file (%s) for ground rules, using stdout instead.", path), ex);
            }
        }
        String header = StringUtils.join("\t", "Weight", "Squared?", "Rule");
        if (includeSatisfaction) {
            header = StringUtils.join("\t", header, "Satisfaction");
        }
        stream.println(header);
        for (GroundRule groundRule : groundRuleStore.getGroundRules()) {
            String row = "";
            double satisfaction = 0.0;
            if (groundRule instanceof WeightedGroundRule) {
                WeightedGroundRule weightedGroundRule = (WeightedGroundRule)groundRule;
                row = StringUtils.join("\t", "" + weightedGroundRule.getWeight(), "" + weightedGroundRule.isSquared(), groundRule.baseToString());
                satisfaction = 1.0 - weightedGroundRule.getIncompatibility();
            } else {
                UnweightedGroundRule unweightedGroundRule = (UnweightedGroundRule)groundRule;
                row = StringUtils.join("\t", ".", "false", groundRule.baseToString());
                satisfaction = 1.0 - unweightedGroundRule.getInfeasibility();
            }
            if (includeSatisfaction) {
                row = StringUtils.join("\t", row, "" + satisfaction);
            }
            stream.println(row);
        }
        if (closeStream) {
            stream.close();
        }
    }

    private Database runInference(Model model, DataStore dataStore, Set<StandardPredicate> closedPredicates, String inferenceName) {
        String path;
        this.log.info("Starting inference with class: {}", (Object)inferenceName);
        Partition targetPartition = dataStore.getPartition(PARTITION_NAME_TARGET);
        Partition observationsPartition = dataStore.getPartition(PARTITION_NAME_OBSERVATIONS);
        Database database = dataStore.getDatabase(targetPartition, closedPredicates, observationsPartition);
        InferenceApplication inferenceApplication = InferenceApplication.getInferenceApplication(inferenceName, model, database);
        if (this.options.hasOption(OPTION_OUTPUT_GROUND_RULES_LONG)) {
            path = this.options.getOptionValue(OPTION_OUTPUT_GROUND_RULES_LONG);
            this.outputGroundRules(inferenceApplication.getGroundRuleStore(), path, false);
        }
        inferenceApplication.inference();
        if (this.options.hasOption(OPTION_OUTPUT_SATISFACTION_LONG)) {
            path = this.options.getOptionValue(OPTION_OUTPUT_SATISFACTION_LONG);
            this.outputGroundRules(inferenceApplication.getGroundRuleStore(), path, true);
        }
        this.log.info("Inference Complete");
        this.outputResults(database, dataStore, closedPredicates);
        return database;
    }

    private void outputResults(Database database, DataStore dataStore, Set<StandardPredicate> closedPredicates) {
        Set<StandardPredicate> openPredicates = dataStore.getRegisteredPredicates();
        openPredicates.removeAll(closedPredicates);
        if (!this.options.hasOption(OPTION_OUTPUT_DIR)) {
            for (StandardPredicate openPredicate : openPredicates) {
                for (GroundAtom groundAtom : database.getAllGroundRandomVariableAtoms(openPredicate)) {
                    System.out.println(groundAtom.toString() + " = " + groundAtom.getValue());
                }
            }
            return;
        }
        String outputDirectoryPath = this.options.getOptionValue(OPTION_OUTPUT_DIR);
        File outputDirectory = new File(outputDirectoryPath);
        outputDirectory.mkdirs();
        for (StandardPredicate standardPredicate : openPredicates) {
            try {
                FileWriter predFileWriter = new FileWriter(new File(outputDirectory, standardPredicate.getName() + ".txt"));
                for (GroundAtom groundAtom : database.getAllGroundRandomVariableAtoms(standardPredicate)) {
                    for (Constant term : groundAtom.getArguments()) {
                        predFileWriter.write(term.toString() + "\t");
                    }
                    predFileWriter.write(Double.toString(groundAtom.getValue()));
                    predFileWriter.write("\n");
                }
                predFileWriter.close();
            }
            catch (IOException ex) {
                this.log.error("Exception writing predicate {}", (Object)standardPredicate);
            }
        }
    }

    private void learnWeights(Model model, DataStore dataStore, Set<StandardPredicate> closedPredicates, String wlaName) {
        String path;
        this.log.info("Starting weight learning with learner: " + wlaName);
        Partition targetPartition = dataStore.getPartition(PARTITION_NAME_TARGET);
        Partition observationsPartition = dataStore.getPartition(PARTITION_NAME_OBSERVATIONS);
        Partition truthPartition = dataStore.getPartition(PARTITION_NAME_LABELS);
        Database randomVariableDatabase = dataStore.getDatabase(targetPartition, closedPredicates, observationsPartition);
        Database observedTruthDatabase = dataStore.getDatabase(truthPartition, dataStore.getRegisteredPredicates(), new Partition[0]);
        WeightLearningApplication learner = WeightLearningApplication.getWLA(wlaName, model.getRules(), randomVariableDatabase, observedTruthDatabase);
        learner.learn();
        if (this.options.hasOption(OPTION_OUTPUT_GROUND_RULES_LONG)) {
            path = this.options.getOptionValue(OPTION_OUTPUT_GROUND_RULES_LONG);
            this.outputGroundRules(learner.getGroundRuleStore(), path, false);
        }
        learner.close();
        if (this.options.hasOption(OPTION_OUTPUT_SATISFACTION_LONG)) {
            path = this.options.getOptionValue(OPTION_OUTPUT_SATISFACTION_LONG);
            this.outputGroundRules(learner.getGroundRuleStore(), path, true);
        }
        randomVariableDatabase.close();
        observedTruthDatabase.close();
        this.log.info("Weight learning complete");
        String modelFilename = this.options.getOptionValue(OPTION_MODEL);
        int prefixPos = modelFilename.lastIndexOf(MODEL_FILE_EXTENSION);
        String learnedFilename = prefixPos == -1 ? modelFilename + MODEL_FILE_EXTENSION : modelFilename.substring(0, prefixPos) + "-learned" + MODEL_FILE_EXTENSION;
        this.log.info("Writing learned model to {}", (Object)learnedFilename);
        String outModel = model.asString();
        outModel = outModel.replaceAll("\\( | \\)", "");
        try (FileWriter learnedFileWriter = new FileWriter(new File(learnedFilename));){
            learnedFileWriter.write(outModel);
        }
        catch (IOException ex) {
            this.log.error("Failed to write learned model:\n" + outModel);
            throw new RuntimeException("Failed to write learned model to: " + learnedFilename, ex);
        }
    }

    private void evaluation(DataStore dataStore, Database predictionDatabase, Set<StandardPredicate> closedPredicates, String evalClassName) {
        this.log.info("Starting evaluation with class: {}.", (Object)evalClassName);
        Set<StandardPredicate> openPredicates = dataStore.getRegisteredPredicates();
        openPredicates.removeAll(closedPredicates);
        Partition targetPartition = dataStore.getPartition(PARTITION_NAME_TARGET);
        Partition observationsPartition = dataStore.getPartition(PARTITION_NAME_OBSERVATIONS);
        Partition truthPartition = dataStore.getPartition(PARTITION_NAME_LABELS);
        boolean closePredictionDB = false;
        if (predictionDatabase == null) {
            closePredictionDB = true;
            predictionDatabase = dataStore.getDatabase(targetPartition, closedPredicates, observationsPartition);
        }
        Database truthDatabase = dataStore.getDatabase(truthPartition, dataStore.getRegisteredPredicates(), new Partition[0]);
        Evaluator evaluator = (Evaluator)Reflection.newObject(evalClassName);
        for (StandardPredicate targetPredicate : openPredicates) {
            if (truthDatabase.countAllGroundAtoms(targetPredicate) == 0) {
                this.log.info("Skipping evaluation for {} since there are no ground truth atoms", (Object)targetPredicate);
                continue;
            }
            evaluator.compute(predictionDatabase, truthDatabase, targetPredicate, !closePredictionDB);
            this.log.info("Evaluation results for {} -- {}", (Object)targetPredicate.getName(), (Object)evaluator.getAllStats());
        }
        if (closePredictionDB) {
            predictionDatabase.close();
        }
        truthDatabase.close();
    }

    private Model loadModel(DataStore dataStore) {
        this.log.info("Loading model from {}", (Object)this.options.getOptionValue(OPTION_MODEL));
        Model model = null;
        try (FileReader reader = new FileReader(new File(this.options.getOptionValue(OPTION_MODEL)));){
            model = ModelLoader.load(dataStore, reader);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load model from file: " + this.options.getOptionValue(OPTION_MODEL), ex);
        }
        this.log.debug(model.toString());
        this.log.info("Model loading complete");
        return model;
    }

    private void run() {
        this.log.info("Running PSL CLI Version {}", (Object)Version.getFull());
        DataStore dataStore = this.initDataStore();
        Set<StandardPredicate> closedPredicates = this.loadData(dataStore);
        Model model = this.loadModel(dataStore);
        Database evalDB = null;
        if (this.options.hasOption(OPERATION_INFER)) {
            evalDB = this.runInference(model, dataStore, closedPredicates, this.options.getOptionValue(OPERATION_INFER, DEFAULT_IA));
        } else if (this.options.hasOption(OPERATION_LEARN)) {
            this.learnWeights(model, dataStore, closedPredicates, this.options.getOptionValue(OPERATION_LEARN, DEFAULT_WLA));
        } else {
            throw new IllegalArgumentException("No valid operation provided.");
        }
        if (this.options.hasOption(OPTION_EVAL)) {
            for (String evaluator : this.options.getOptionValues(OPTION_EVAL)) {
                this.evaluation(dataStore, evalDB, closedPredicates, evaluator);
            }
            this.log.info("Evaluation complete.");
        }
        if (evalDB != null) {
            evalDB.close();
        }
        dataStore.close();
    }

    private static String getHostname() {
        String hostname = "unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    private static Options setupOptions() {
        Options options = new Options();
        OptionGroup mainCommand = new OptionGroup();
        mainCommand.addOption(Option.builder(OPERATION_INFER).longOpt(OPERATION_INFER_LONG).desc("Run MAP inference. You can optionally supply a fully qualified name for an inference application (defaults to " + DEFAULT_IA + ").").hasArg().argName("inferenceMethod").optionalArg(true).build());
        mainCommand.addOption(Option.builder(OPERATION_LEARN).longOpt(OPERATION_LEARN_LONG).desc("Run weight learning. You can optionally supply a fully qualified name for a weight learner (defaults to " + DEFAULT_WLA + ").").hasArg().argName("learner").optionalArg(true).build());
        mainCommand.addOption(Option.builder(OPTION_HELP).longOpt(OPTION_HELP_LONG).desc("Print this help message and exit").build());
        mainCommand.addOption(Option.builder(OPTION_VERSION).longOpt(OPTION_VERSION_LONG).desc("Print the PSL version and exit").build());
        mainCommand.setRequired(true);
        options.addOptionGroup(mainCommand);
        options.addOption(Option.builder(OPTION_DATA).longOpt(OPTION_DATA_LONG).desc("Path to PSL data file").hasArg().argName("path").build());
        options.addOption(Option.builder().longOpt(OPTION_DB_H2_PATH).desc("Path for H2 database file (defaults to 'cli_<user name>@<host name>' ('" + DEFAULT_H2_DB_PATH + "')). Not compatible with the '--" + OPTION_DB_POSTGRESQL_NAME + "' option.").hasArg().argName("path").build());
        options.addOption(Option.builder().longOpt(OPTION_DB_POSTGRESQL_NAME).desc("Name for the PostgreSQL database to use (defaults to psl_cli). Not compatible with the '--h2path' option. Currently only local databases without credentials are supported.").hasArg().argName("name").optionalArg(true).build());
        options.addOption(Option.builder(OPTION_EVAL).longOpt(OPTION_EVAL_LONG).desc("Run the named evaluator (" + Evaluator.class.getName() + ") on any open predicate with a 'truth' partition. If multiple evaluators are specific, they will each be run.").hasArgs().argName("evaluator ...").build());
        options.addOption(Option.builder(OPTION_INT_IDS).longOpt(OPTION_INT_IDS_LONG).desc("Use integer identifiers (UniqueIntID) instead of string identifiers (UniqueStringID).").build());
        options.addOption(Option.builder(OPTION_LOG4J).longOpt(OPTION_LOG4J_LONG).desc("Optional log4j properties file path").hasArg().argName("path").build());
        options.addOption(Option.builder(OPTION_MODEL).longOpt(OPTION_MODEL_LONG).desc("Path to PSL model file").hasArg().argName("path").build());
        options.addOption(Option.builder(OPTION_OUTPUT_DIR).longOpt(OPTION_OUTPUT_DIR_LONG).desc("Optional path for writing results to filesystem (default is STDOUT)").hasArg().argName("path").build());
        options.addOption(Option.builder().longOpt(OPTION_OUTPUT_GROUND_RULES_LONG).desc("Output the program's ground rules. If a path is specified, the ground rules will be output there. Otherwise, they will be output to stdout (not the logger).").hasArg().argName("path").optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_OUTPUT_SATISFACTION_LONG).desc("Output the program's ground rules along with their satisfaction values after inference. If a path is specified, the ground rules will be output there. Otherwise, they will be output to stdout (not the logger).").hasArg().argName("path").optionalArg(true).build());
        options.addOption(Option.builder(OPTION_PROPERTIES_FILE).longOpt(OPTION_PROPERTIES_FILE_LONG).desc("Optional PSL properties file path").hasArg().argName("path").build());
        options.addOption(Option.builder(OPTION_PROPERTIES).argName("name=value").desc("Directly specify PSL properties (overrides options set via --properties). See https://github.com/linqs/psl/wiki/Configuration-Options for a list of available options. Log4j properties (properties starting with 'log4j') will be passed to the logger. 'log4j.threshold=DEBUG', for example, will be passed to log4j and set the global logging threshold.").hasArg().numberOfArgs(2).valueSeparator('=').build());
        return options;
    }

    private static HelpFormatter getHelpFormatter() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(new Comparator<Option>(){

            @Override
            public int compare(Option o1, Option o2) {
                String name2;
                String name1 = o1.getOpt();
                if (name1 == null) {
                    name1 = o1.getLongOpt();
                }
                if ((name2 = o2.getOpt()) == null) {
                    name2 = o2.getLongOpt();
                }
                if (name1.equals(Launcher.OPERATION_INFER)) {
                    return -1;
                }
                if (name2.equals(Launcher.OPERATION_INFER)) {
                    return 1;
                }
                if (name1.equals(Launcher.OPERATION_LEARN)) {
                    return -1;
                }
                if (name2.equals(Launcher.OPERATION_LEARN)) {
                    return 1;
                }
                if (o1.isRequired() && !o2.isRequired()) {
                    return -1;
                }
                if (!o1.isRequired() && o2.isRequired()) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        helpFormatter.setWidth(100);
        return helpFormatter;
    }

    private static CommandLine parseOptions(String[] args) {
        Options options = Launcher.setupOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine commandLineOptions = null;
        try {
            commandLineOptions = parser.parse(options, args);
        }
        catch (ParseException ex) {
            System.err.println("Command line error: " + ex.getMessage());
            Launcher.getHelpFormatter().printHelp("psl", options, true);
            System.exit(1);
        }
        if (commandLineOptions.hasOption(OPTION_HELP)) {
            Launcher.initDefaultLogger();
            Launcher.getHelpFormatter().printHelp("psl", options, true);
            return null;
        }
        if (commandLineOptions.hasOption(OPTION_VERSION)) {
            Launcher.initDefaultLogger();
            System.out.println("PSL CLI Version " + Version.getFull());
            return null;
        }
        if (!commandLineOptions.hasOption(OPTION_DATA)) {
            System.out.println(String.format("Missing required option: --%s/-%s.", OPTION_DATA_LONG, OPTION_DATA));
            Launcher.getHelpFormatter().printHelp("psl", options, true);
            System.exit(1);
        }
        if (!commandLineOptions.hasOption(OPTION_MODEL)) {
            System.out.println(String.format("Missing required option: --%s/-%s.", OPTION_MODEL_LONG, OPTION_MODEL));
            Launcher.getHelpFormatter().printHelp("psl", options, true);
            System.exit(1);
        }
        if (commandLineOptions.hasOption(OPTION_DB_H2_PATH) && commandLineOptions.hasOption(OPTION_DB_POSTGRESQL_NAME)) {
            System.err.println("Command line error: Options '--h2path' and '--postgres' are not compatible.");
            Launcher.getHelpFormatter().printHelp("psl", options, true);
            System.exit(2);
        }
        return commandLineOptions;
    }

    public static void main(String[] args) {
        Launcher.main(args, false);
    }

    public static void main(String[] args, boolean rethrow) {
        try {
            CommandLine commandLineOptions = Launcher.parseOptions(args);
            if (commandLineOptions == null) {
                return;
            }
            Launcher pslLauncher = new Launcher(commandLineOptions);
            pslLauncher.run();
        }
        catch (Exception ex) {
            if (rethrow) {
                throw new RuntimeException("Failed to run CLI: " + ex.getMessage(), ex);
            }
            System.err.println("Unexpected exception!");
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

