/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.ReadableDatabase;
import org.linqs.psl.database.WritableDatabase;
import org.linqs.psl.database.atom.AtomCache;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.util.IteratorUtils;

public abstract class Database
implements ReadableDatabase,
WritableDatabase {
    protected final DataStore parentDataStore;
    protected final Partition writePartition;
    protected final int writeID;
    protected final List<Partition> readPartitions;
    protected final List<Integer> readIDs;
    protected final List<Integer> allPartitionIDs;
    protected final AtomCache cache;
    protected boolean closed;

    public Database(DataStore parent, Partition write, Partition[] read) {
        this.parentDataStore = parent;
        this.writePartition = write;
        this.writeID = write.getID();
        this.readPartitions = Arrays.asList(read);
        this.readIDs = new ArrayList<Integer>(read.length);
        for (int i = 0; i < read.length; ++i) {
            this.readIDs.add(read[i].getID());
        }
        if (this.readIDs.contains(new Integer(this.writeID))) {
            this.readIDs.remove(new Integer(this.writeID));
        }
        this.allPartitionIDs = new ArrayList<Integer>(this.readIDs.size() + 1);
        this.allPartitionIDs.addAll(this.readIDs);
        this.allPartitionIDs.add(this.writeID);
        this.cache = new AtomCache(this);
    }

    public abstract GroundAtom getAtom(StandardPredicate var1, boolean var2, Constant ... var3);

    @Override
    public boolean hasAtom(StandardPredicate predicate, Constant ... arguments) {
        return this.getAtom(predicate, false, arguments) != null;
    }

    @Override
    public int countAllGroundAtoms(StandardPredicate predicate) {
        return this.countAllGroundAtoms(predicate, this.allPartitionIDs);
    }

    public abstract int countAllGroundAtoms(StandardPredicate var1, List<Integer> var2);

    @Override
    public int countAllGroundRandomVariableAtoms(StandardPredicate predicate) {
        if (this.isClosed(predicate)) {
            return 0;
        }
        ArrayList<Integer> partitions = new ArrayList<Integer>(1);
        partitions.add(this.writeID);
        return this.countAllGroundAtoms(predicate, partitions);
    }

    @Override
    public Iterable<GroundAtom> getAllCachedAtoms() {
        return this.cache.getCachedAtoms();
    }

    @Override
    public Iterable<RandomVariableAtom> getAllCachedRandomVariableAtoms() {
        return this.cache.getCachedRandomVariableAtoms();
    }

    @Override
    public List<GroundAtom> getAllGroundAtoms(StandardPredicate predicate) {
        return this.getAllGroundAtoms(predicate, this.allPartitionIDs);
    }

    public abstract List<GroundAtom> getAllGroundAtoms(StandardPredicate var1, List<Integer> var2);

    @Override
    public List<RandomVariableAtom> getAllGroundRandomVariableAtoms(StandardPredicate predicate) {
        if (this.isClosed(predicate)) {
            return new ArrayList<RandomVariableAtom>();
        }
        ArrayList<Integer> partitions = new ArrayList<Integer>(1);
        partitions.add(this.writeID);
        List<GroundAtom> groundAtoms = this.getAllGroundAtoms(predicate, partitions);
        ArrayList<RandomVariableAtom> atoms = new ArrayList<RandomVariableAtom>(groundAtoms.size());
        for (GroundAtom atom : groundAtoms) {
            if (atom instanceof ObservedAtom) {
                throw new IllegalStateException(String.format("Found a ground atom (%s) that is both observed and a target. An atom can only be one at a time. Check your data files.", atom));
            }
            atoms.add((RandomVariableAtom)atom);
        }
        return atoms;
    }

    @Override
    public List<ObservedAtom> getAllGroundObservedAtoms(StandardPredicate predicate) {
        if (this.readIDs.size() == 0) {
            return new ArrayList<ObservedAtom>();
        }
        List<GroundAtom> groundAtoms = this.getAllGroundAtoms(predicate, this.readIDs);
        ArrayList<ObservedAtom> atoms = new ArrayList<ObservedAtom>(groundAtoms.size());
        for (GroundAtom atom : groundAtoms) {
            if (atom instanceof RandomVariableAtom) {
                throw new IllegalStateException(String.format("Found a ground atom (%s) that is both observed and a target. An atom can only be one at a time. Check your data files.", atom));
            }
            atoms.add((ObservedAtom)atom);
        }
        return atoms;
    }

    @Override
    public void commit(RandomVariableAtom atom) {
        ArrayList<RandomVariableAtom> atoms = new ArrayList<RandomVariableAtom>(1);
        atoms.add(atom);
        this.commit(atoms);
    }

    @Override
    public void commitCachedAtoms() {
        this.commitCachedAtoms(false);
    }

    @Override
    public void commitCachedAtoms(boolean onlyPersisted) {
        if (!onlyPersisted) {
            this.commit(this.getAllCachedRandomVariableAtoms());
        } else {
            this.commit(IteratorUtils.filter(this.getAllCachedRandomVariableAtoms(), new IteratorUtils.FilterFunction<RandomVariableAtom>(){

                @Override
                public boolean keep(RandomVariableAtom atom) {
                    return atom.getPersisted();
                }
            }));
        }
    }

    public DataStore getDataStore() {
        return this.parentDataStore;
    }

    public List<Partition> getReadPartitions() {
        return Collections.unmodifiableList(this.readPartitions);
    }

    public Partition getWritePartition() {
        return this.writePartition;
    }

    @Override
    public int getCachedRVACount() {
        return this.cache.getRVACount();
    }
}

