/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.atom;

import java.util.Map;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;

public class QueryAtom
extends Atom {
    public QueryAtom(Predicate predicate, Term ... args) {
        super(predicate, args);
    }

    public void assume(Predicate predicate, Term ... args) {
        this.init(false, false, predicate, args);
    }

    public GroundAtom ground(AtomManager atomManager, ResultList res, int resultIndex) {
        return this.ground(atomManager, res, resultIndex, new Constant[this.arguments.length]);
    }

    public GroundAtom ground(AtomManager atomManager, ResultList res, int resultIndex, Constant[] newArgs) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] instanceof Variable) {
                newArgs[i] = res.get(resultIndex, (Variable)this.arguments[i]);
                continue;
            }
            if (this.arguments[i] instanceof Constant) {
                newArgs[i] = (Constant)this.arguments[i];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type of Term.");
        }
        return atomManager.getAtom(this.predicate, newArgs);
    }

    public GroundAtom ground(AtomManager atomManager, Constant[] queryResults, Map<Variable, Integer> projectionMap, Constant[] newArgs) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] instanceof Variable) {
                newArgs[i] = queryResults[projectionMap.get((Variable)this.arguments[i])];
                continue;
            }
            if (this.arguments[i] instanceof Constant) {
                newArgs[i] = (Constant)this.arguments[i];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized type of Term.");
        }
        return atomManager.getAtom(this.predicate, newArgs);
    }

    @Override
    public VariableTypeMap collectVariables(VariableTypeMap varMap) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!(this.arguments[i] instanceof Variable)) continue;
            ConstantType t = this.predicate.getArgumentType(i);
            varMap.addVariable((Variable)this.arguments[i], t);
        }
        return varMap;
    }
}

