/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate;

import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.term.ConstantType;

public class StandardPredicate
extends Predicate {
    private boolean isBlock = false;

    private StandardPredicate(String name, ConstantType[] types) {
        super(name, types);
        for (ConstantType type : types) {
            if (type != ConstantType.DeferredFunctionalUniqueID) continue;
            throw new IllegalArgumentException(name + " -- DeferredFunctionalUniqueID can only be used with FunctionalPredicates (and should only be used in rare cases.");
        }
    }

    public void setBlock(boolean isBlock) {
        this.isBlock = isBlock;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public static StandardPredicate get(String name) {
        Predicate predicate = Predicate.get(name);
        if (predicate == null) {
            return null;
        }
        if (!(predicate instanceof StandardPredicate)) {
            throw new ClassCastException("Predicate (" + name + ") is not a StandardPredicate.");
        }
        return (StandardPredicate)predicate;
    }

    public static StandardPredicate get(String name, ConstantType ... types) {
        StandardPredicate predicate = StandardPredicate.get(name);
        if (predicate == null) {
            return new StandardPredicate(name, types);
        }
        if (predicate.getArity() != types.length) {
            throw new IllegalArgumentException(name + " -- Size mismatch for predicate types. Existing predicate: " + predicate.getArity() + ", Query Predicate: " + types.length);
        }
        for (int i = 0; i < types.length; ++i) {
            if (predicate.getArgumentType(i).equals((Object)types[i])) continue;
            throw new IllegalArgumentException(name + " -- Type mismatch on " + i + ". Existing predicate: " + (Object)((Object)predicate.getArgumentType(i)) + ", Query Predicate: " + (Object)((Object)types[i]));
        }
        return predicate;
    }
}

