/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtomOrAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariableOrTerm;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Cardinality;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Coefficient;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.util.HashCode;

public class ArithmeticRuleExpression {
    protected final List<Coefficient> coeffs;
    protected final List<SummationAtomOrAtom> atoms;
    protected final FunctionComparator comparator;
    protected final Coefficient c;
    protected final Set<Variable> vars;
    protected final Set<SummationVariable> sumVars;
    private int hash;

    public ArithmeticRuleExpression(List<Coefficient> coeffs, List<SummationAtomOrAtom> atoms, FunctionComparator comparator, Coefficient c) {
        this.coeffs = Collections.unmodifiableList(coeffs);
        this.atoms = Collections.unmodifiableList(atoms);
        this.comparator = comparator;
        this.c = c;
        HashSet<Variable> vars = new HashSet<Variable>();
        HashSet<SummationVariable> sumVars = new HashSet<SummationVariable>();
        HashSet<String> sumVarNames = new HashSet<String>();
        if (atoms.size() == 0) {
            throw new IllegalArgumentException("Cannot have an arithmetic rule without atoms.");
        }
        for (SummationAtomOrAtom saoa : this.getAtoms()) {
            if (saoa instanceof SummationAtom) {
                for (SummationVariableOrTerm summationVariableOrTerm : ((SummationAtom)saoa).getArguments()) {
                    if (summationVariableOrTerm instanceof Variable) {
                        vars.add((Variable)summationVariableOrTerm);
                        continue;
                    }
                    if (!(summationVariableOrTerm instanceof SummationVariable)) continue;
                    if (sumVars.contains((SummationVariable)summationVariableOrTerm)) {
                        throw new IllegalArgumentException("Each summation variable in an ArithmeticRuleExpression must be unique.");
                    }
                    sumVars.add((SummationVariable)summationVariableOrTerm);
                    sumVarNames.add(((SummationVariable)summationVariableOrTerm).getVariable().getName());
                }
                continue;
            }
            for (SummationVariableOrTerm summationVariableOrTerm : ((Atom)saoa).getArguments()) {
                if (!(summationVariableOrTerm instanceof Variable)) continue;
                vars.add((Variable)summationVariableOrTerm);
            }
        }
        for (Variable var : vars) {
            if (!sumVarNames.contains(var.getName())) continue;
            throw new IllegalArgumentException(String.format("Summation variable (+%s) cannot be used as a normal variable (%s).", var.getName(), var.getName()));
        }
        for (Coefficient coefficient : coeffs) {
            String name;
            if (!(coefficient instanceof Cardinality) || sumVarNames.contains(name = ((Cardinality)coefficient).getSummationVariable().getVariable().getName())) continue;
            throw new IllegalArgumentException(String.format("Cannot use variable (%s) in cardinality. Only summation variables can be used in cardinality.", name));
        }
        this.vars = Collections.unmodifiableSet(vars);
        this.sumVars = Collections.unmodifiableSet(sumVars);
        this.hash = HashCode.build(HashCode.build((Object)comparator), c);
        for (Coefficient coeff : coeffs) {
            this.hash = HashCode.build(coeff);
        }
        for (SummationAtomOrAtom atom : atoms) {
            this.hash = HashCode.build(atom);
        }
    }

    public List<Coefficient> getAtomCoefficients() {
        return this.coeffs;
    }

    public List<SummationAtomOrAtom> getAtoms() {
        return this.atoms;
    }

    public FunctionComparator getComparator() {
        return this.comparator;
    }

    public Coefficient getFinalCoefficient() {
        return this.c;
    }

    public Set<Variable> getVariables() {
        return this.vars;
    }

    public Set<SummationVariable> getSummationVariables() {
        return this.sumVars;
    }

    public Formula getQueryFormula() {
        ArrayList<Atom> queryAtoms = new ArrayList<Atom>();
        for (SummationAtomOrAtom atom : this.atoms) {
            if (atom instanceof SummationAtom) {
                queryAtoms.add(((SummationAtom)atom).getQueryAtom());
                continue;
            }
            queryAtoms.add((Atom)atom);
        }
        if (queryAtoms.size() == 1) {
            return (Formula)queryAtoms.get(0);
        }
        return new Conjunction(queryAtoms.toArray(new Formula[0]));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.coeffs.size() > 0) {
            for (int i = 0; i < this.coeffs.size(); ++i) {
                if (i != 0) {
                    s.append(" + ");
                }
                s.append(this.coeffs.get(i));
                s.append(" * ");
                s.append(this.atoms.get(i));
            }
        } else {
            s.append("0.0");
        }
        s.append(" ");
        s.append((Object)this.comparator);
        s.append(" ");
        s.append(this.c);
        return s.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ArithmeticRuleExpression otherExpression = (ArithmeticRuleExpression)other;
        if (this.hash != otherExpression.hash) {
            return false;
        }
        if (this.comparator != otherExpression.comparator || this.c != otherExpression.c) {
            return false;
        }
        if (this.atoms.size() != otherExpression.atoms.size()) {
            return false;
        }
        for (int thisIndex = 0; thisIndex < this.atoms.size(); ++thisIndex) {
            int otherIndex = otherExpression.atoms.indexOf(this.atoms.get(thisIndex));
            if (otherIndex == -1) {
                return false;
            }
            if (this.atoms.get(thisIndex).equals(otherExpression.atoms.get(otherIndex)) && this.coeffs.get(thisIndex).equals(otherExpression.coeffs.get(otherIndex))) continue;
            return false;
        }
        return true;
    }
}

